/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.change.HandleEvent;
import kd.scm.pds.common.change.HandleResult;
import kd.scm.pds.common.change.IDataHandleService;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcSupplierInvalidPurlistBiddoc
implements IDataHandleService {
    private static final long serialVersionUID = 8634249315457733232L;

    public HandleResult handle(HandleEvent handleEvent) {
        String message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807\uff1a\u6309\u6807\u6bb5\u5e9f\u6807\u91c7\u8d2d\u6e05\u5355\u5931\u8d25\u3002", (String)"SrcSupplierInvalidPurlistBiddoc_0", (String)"scm-src-common", (Object[])new Object[0]);
        HandleResult result = new HandleResult();
        result.setSuccess(false);
        this.invalidPurlistBiddoc(handleEvent.getObj(), "src_purlistf7");
        this.invalidPurlistBiddoc(handleEvent.getObj(), "src_biddoctplf7");
        this.deleteBidassess(handleEvent.getObj());
        result.setSuccess(true);
        message = ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u5e9f\u6807\uff1a\u6309\u6807\u6bb5\u5e9f\u6807\u9080\u8bf7\u4f9b\u5e94\u5546\u6210\u529f\u3002", (String)"SrcSupplierInvalidPurlistBiddoc_1", (String)"scm-src-common", (Object[])new Object[0]);
        result.setMessage(message);
        this.handleLog(handleEvent, message);
        return result;
    }

    protected void invalidPurlistBiddoc(DynamicObject bidChangeObj, String entityName) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        Boolean ismultipackage = bidChangeObj.getDynamicObject("project").getBoolean("ismultipackage");
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)bidChangeObj, (String)"src_supplierinvalid");
        DynamicObjectCollection rows = compDataObj.getDynamicObjectCollection("entryentity");
        List discardList = rows.stream().filter(e -> e.getBoolean("isdiscard")).collect(Collectors.toList());
        Set supplierIds = discardList.stream().map(e -> e.getLong("supplier.id")).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("supplier", "in", supplierIds);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> purlistList = new ArrayList<DynamicObject>(purlistObjs.length);
        for (DynamicObject row : discardList) {
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("supplier"));
            long packageId = SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package"));
            List objs = null;
            objs = ismultipackage != false ? Arrays.stream(purlistObjs).filter(e -> e.getLong("supplier.id") == supplierId && e.getLong("package.id") == packageId).collect(Collectors.toList()) : Arrays.stream(purlistObjs).filter(e -> e.getLong("supplier.id") == supplierId).collect(Collectors.toList());
            if (objs.size() == 0) continue;
            for (DynamicObject obj : objs) {
                obj.set("entrystatus", (Object)ProjectStatusEnums.INVALID.getValue());
                if ("src_purlistf7".equals(entityName)) {
                    PdsPurlistUtils.clearDiscardedValue((DynamicObject)obj);
                }
                purlistList.add(obj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(purlistList);
    }

    protected void deleteBidassess(DynamicObject bidChangeObj) {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)bidChangeObj.getDynamicObject("project"));
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"src_bidassess_biz", (QFilter[])new QFilter[]{qFilter});
    }

    public void handleLog(HandleEvent handleEvent, String message) {
        DynamicObject bidChange = handleEvent.getObj();
        SrcBidChangeUtil.log(bidChange, message);
    }
}

