/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.change;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.change.IDataValidateService;
import kd.scm.pds.common.change.ValidateEvent;
import kd.scm.pds.common.change.ValidateResult;
import kd.scm.src.common.util.SrcBidChangeUtil;

public class SrcVieOpendateValidatorService
implements IDataValidateService {
    private static final long serialVersionUID = -2404236449167779325L;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ValidateResult validate(ValidateEvent validateEvent) {
        Date replyDate;
        ValidateResult result = SrcBidChangeUtil.commonValidate(validateEvent, "src_timechg");
        if (!result.isSuccess()) {
            return result;
        }
        DynamicObject compDataObj = result.getChgCompObj();
        Date vieOpenDate = compDataObj.getDate("newplanopendate");
        if (null == vieOpenDate && (vieOpenDate = compDataObj.getDate("planopendate")) == null) {
            return result;
        }
        Date stopBidDate = compDataObj.getDate("newstopbiddate");
        if (null == stopBidDate) {
            stopBidDate = compDataObj.getDate("stopbiddate");
        }
        if (null == (replyDate = compDataObj.getDate("newreplydate"))) {
            replyDate = compDataObj.getDate("replydate");
        }
        StringBuilder message = new StringBuilder();
        if (replyDate != null && !vieOpenDate.after(replyDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u62a5\u540d\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcVieOpendateValidatorService_4", (String)"scm-src-common", (Object[])new Object[0]), sdf.format(replyDate), sdf.format(vieOpenDate)));
        }
        if (stopBidDate != null && !vieOpenDate.after(stopBidDate)) {
            message.append(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u4e0d\u80fd\u665a\u4e8e\u9884\u8ba1\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4(%2$s)\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"SrcVieOpendateValidatorService_5", (String)"scm-src-common", (Object[])new Object[0]), sdf.format(stopBidDate), sdf.format(vieOpenDate)));
        }
        if (message.length() > 0) {
            result.setSuccess(false);
            result.setMessage(message.toString());
        }
        return result;
    }
}

