/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.comptpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.BizLog;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcDecisionUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcDecisionCompTplServiceImpl
extends PdsCompTplServiceImpl {
    private static final String ISOTHEROPINVOKESAVE = "isOtherOpInvokeSave";
    Object hasPackageAmountComp = null;

    public void propertyChanged(PdsCompTplContext context) {
        this.initParam(context);
        PropertyChangedArgs e = context.getPropertyChangeArgs();
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("isdecisionresult".equals(key)) {
            if (((Boolean)newValue).booleanValue()) {
                this.addComponent("src_decision_result");
            } else {
                this.removeComponent("src_decision_result");
            }
        }
        super.propertyChanged(context);
    }

    public Map<String, Object> getCompParams(String compKey) {
        HashMap<String, Object> refreshMap = new HashMap<String, Object>(8);
        IPageCache cache = this.getPageCache();
        refreshMap.put("isTemplateChanged", cache.get(compKey + "_" + "isTemplateChanged"));
        return refreshMap;
    }

    public void beforeDoOperation(PdsCompTplContext context) {
        this.initParam(context);
        BeforeDoOperationEventArgs beforeDoOperation = context.getBeforeDoOperationEventArgs();
        String opKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey();
        boolean isOpen = false;
        switch (opKey) {
            case "allopen": 
            case "tecopen": 
            case "bizopen": {
                isOpen = true;
            }
            case "calculate": 
            case "recalculate": 
            case "ratiocalculate": 
            case "addsupplier": 
            case "batchdecision": {
                boolean isSuccess;
                if (isOpen) {
                    this.getPageCache().put(ISOTHEROPINVOKESAVE, "1");
                }
                if (!(isSuccess = this.doOperation("save"))) {
                    beforeDoOperation.setCancel(true);
                }
                this.getPageCache().remove(ISOTHEROPINVOKESAVE);
                break;
            }
            case "save": {
                super.beforeDoOperation(context);
                if (beforeDoOperation.isCancel()) break;
                SrcDecisionUtil.saveAmount(this.getView(), this.getModel());
                break;
            }
            case "submit": {
                if (!this.continueDoOpByLoadedComp(beforeDoOperation)) break;
                SrcDecisionUtil.saveAmount(this.getView(), this.getModel());
                this.saveData();
                this.setParentId();
                if (this.doOperation(opKey)) break;
                beforeDoOperation.setCancel(true);
                return;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    public boolean isDoCompOperation(String operateKey, String entityKey, boolean isAttach) {
        boolean isDoCompOperation = super.isDoCompOperation(operateKey, entityKey, isAttach);
        if (isAttach) {
            String pageId = this.getPageCache().get(entityKey);
            IFormView compView = SessionManager.getCurrent().getView(pageId);
            if (null != compView && !this.hasPackageAmountComp()) {
                switch (operateKey) {
                    case "save": 
                    case "submit": {
                        SrcPurListUtil.writeBackSrcEntryData(compView, this.getView());
                        break;
                    }
                }
            }
        } else {
            switch (operateKey) {
                case "save": 
                case "submit": {
                    String otherInvokeSave;
                    if (!"src_decisionsum_sup".equals(entityKey) || null == (otherInvokeSave = this.getPageCache().get(ISOTHEROPINVOKESAVE))) break;
                    return false;
                }
            }
        }
        return isDoCompOperation;
    }

    private boolean hasPackageAmountComp() {
        if (null != this.hasPackageAmountComp) {
            return (Boolean)this.hasPackageAmountComp;
        }
        DynamicObject obj = this.getModel().getDataEntity(true);
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj, (boolean)false);
        this.hasPackageAmountComp = compKeyList.contains("src_pkgamount") ? Boolean.TRUE : Boolean.FALSE;
        return (Boolean)this.hasPackageAmountComp;
    }

    public List<String> getAttachCompKeyList() {
        boolean isAddPurList;
        DynamicObject template = this.getModel().getDataEntity().getDynamicObject("template");
        if (null != template && (isAddPurList = template.getBoolean("isaddpurlist"))) {
            return new ArrayList<String>();
        }
        return super.getAttachCompKeyList();
    }

    public QFilter getCompQfilter(Object pkValue, String entityKey, String compKey) {
        if (entityKey.equals("src_finished") || entityKey.equals("src_terminated")) {
            return super.getCompQfilter(pkValue, "src_decision", compKey);
        }
        QFilter filter = null;
        boolean isNeddFilterEntityKey = this.isNeedFilterEntityKey(entityKey, compKey);
        if (isNeddFilterEntityKey) {
            Set entityKeys = PdsCommonUtils.buildSet((String[])new String[]{"src_predecision", "src_decision"});
            filter = TemplateUtil.getComponentQfilter((Object)String.valueOf(pkValue), (Set)entityKeys, (String)compKey);
        } else {
            filter = TemplateUtil.getComponentQfilter((String)String.valueOf(pkValue), (String)compKey);
        }
        return filter;
    }

    public boolean isNeedFilterEntityKey(String entityKey, String compKey) {
        boolean isNeddFilterEntityKey = false;
        try {
            boolean isPurListComp;
            DynamicObject data = this.getModel().getDataEntity();
            DynamicObject sourceObj = data.getDynamicObject("sourceclass");
            if (null != sourceObj && Objects.equals("C011402", sourceObj.getString("number")) && (isPurListComp = SrcPurListUtil.isPurlistComp(this.getView(), this.getModel(), compKey))) {
                isNeddFilterEntityKey = true;
            }
        }
        catch (Exception e) {
            BizLog.log((String)e.getMessage());
        }
        return isNeddFilterEntityKey;
    }

    public DynamicObject getCompRegData(String entityKey, String compKey) {
        if (entityKey.equals("src_finished") || entityKey.equals("src_terminated")) {
            return super.getCompRegData("src_decision", compKey);
        }
        return super.getCompRegData(entityKey, compKey);
    }

    public boolean isShowComponent(String compKey) {
        String openStatus = this.getModel().getDataEntity().getString("openstatus");
        switch (compKey) {
            case "src_bidopen_tender": 
            case "src_tenderinfo_summary": 
            case "src_tender_quick": 
            case "src_tenderinfo": 
            case "src_biddiscard": {
                return PdsCommonUtils.isShowTenderBeforeBidOpen((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_decision_result": {
                boolean isdecisionresult = this.getModel().getDataEntity().getBoolean("isdecisionresult");
                return isdecisionresult;
            }
            case "src_purlist_tieredprice": {
                String tieredType = this.getModel().getDataEntity().getString("tieredtype");
                if ("3".equals(tieredType)) {
                    return !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus);
                }
                return false;
            }
            case "src_bidopen_open": {
                return !PdsCommonUtils.isOpenBySupplier((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_supplier_open": {
                return PdsCommonUtils.isOpenBySupplier((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_quotebillquery": 
            case "src_quotebill_attach": {
                return !BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) && !BidOpenStatusEnums.NEGOTIATE.getValue().equals(openStatus);
            }
            case "src_purlist_item": {
                return PdsCommonUtils.isShowPurlistItemBeforeOpen((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_manualscore": {
                return this.getModel().getDataEntity().getBoolean("ismanualscore");
            }
        }
        return super.isShowComponent(compKey);
    }
}

