/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.comptpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.src.common.util.SrcBidCompTplUtil;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcProjectCompTplServiceImpl
extends PdsCompTplServiceImpl {
    public void propertyChanged(PdsCompTplContext context) {
        this.initParam(context);
        PropertyChangedArgs e = context.getPropertyChangeArgs();
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "issplitdoc": {
                if (((Boolean)newValue).booleanValue() && SrcPurListUtil.checkPurlistStatus(this.getModel(), BillStatusEnum.AUDIT.getVal())) {
                    this.addComponent("src_biddoc_tnd");
                    break;
                }
                this.removeComponent("src_biddoc_tnd");
                break;
            }
            case "template": {
                IPageCache cache = this.getPageCache();
                List compKeyList = TemplateUtil.getCompKeyList((DynamicObject)this.getModel().getDataEntity(true));
                for (String compKey : compKeyList) {
                    cache.put(compKey + "_" + "isTemplateChanged", "1");
                }
                break;
            }
        }
        super.propertyChanged(context);
    }

    public Map<String, Object> getCompParams(String compKey) {
        HashMap<String, Object> refreshMap = new HashMap<String, Object>(8);
        IPageCache cache = this.getPageCache();
        refreshMap.put("isTemplateChanged", cache.get(compKey + "_" + "isTemplateChanged"));
        return refreshMap;
    }

    public boolean isShowComponent(String compKey) {
        String managetype = this.getModel().getDataEntity().getString("managetype");
        boolean isSplitDoc = this.getModel().getDataEntity(true).getBoolean("issplitdoc");
        boolean isPurlistAudit = SrcPurListUtil.checkPurlistStatus(this.getModel(), BillStatusEnum.AUDIT.getVal());
        boolean isContainPurlist = SrcPurListUtil.isContainPurlistComp(this.getView(), this.getModel());
        if (!isPurlistAudit && !isContainPurlist && SrcPurListUtil.isPurlistComp(this.getView(), this.getModel(), compKey)) {
            return false;
        }
        switch (compKey) {
            case "src_bidopen_tender": 
            case "src_tenderinfo_summary": 
            case "src_tender_quick": 
            case "src_tenderinfo": 
            case "src_biddiscard": {
                return PdsCommonUtils.isShowTenderBeforeBidOpen((DynamicObject)this.getModel().getDataEntity());
            }
            case "src_biddoc_tnd": {
                return isSplitDoc && (isPurlistAudit || isContainPurlist);
            }
            case "src_biddoc_src": {
                return isPurlistAudit || isContainPurlist;
            }
            case "src_supplier_invite": {
                return (isPurlistAudit || isContainPurlist) && !"3".equals(managetype);
            }
            case "src_itemsupplier": {
                return (isPurlistAudit || isContainPurlist) && "3".equals(managetype);
            }
            case "src_paymanage_cfg": {
                return isPurlistAudit || isContainPurlist;
            }
        }
        return super.isShowComponent(compKey);
    }

    public void beforeDoOperation(PdsCompTplContext context) {
        String opKey;
        this.initParam(context);
        BeforeDoOperationEventArgs beforeDoOperation = context.getBeforeDoOperationEventArgs();
        switch (opKey = ((AbstractOperate)beforeDoOperation.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.updateTplEntryData();
                this.initCurrNode();
                this.validateOrCreateBillNo();
                super.beforeDoOperation(context);
                break;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    private void initCurrNode() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject currNode = obj.getDynamicObject("currentnode");
        if (null != currNode) {
            return;
        }
        DynamicObject processingNode = SrcBidCompTplUtil.getProcessingNode(obj);
        if (null == processingNode) {
            DynamicObjectCollection entryNodeCols = obj.getDynamicObjectCollection("entrymainflow");
            if (entryNodeCols.size() > 0) {
                currNode = ((DynamicObject)entryNodeCols.get(0)).getDynamicObject("biznode");
            }
        } else {
            currNode = processingNode.getDynamicObjectType() instanceof SubEntryType ? processingNode.getDynamicObject("subbiznode") : processingNode.getDynamicObject("biznode");
        }
        this.getModel().setValue("currentnode", (Object)currNode);
    }

    private void validateOrCreateBillNo() {
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj.getInt("version") > 1) {
            return;
        }
        PdsCommonUtils.setBillNo((String)this.getView().getEntityId(), (DynamicObject)obj);
    }

    private void updateTplEntryData() {
        DynamicObject nodeRow;
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObject template = obj.getDynamicObject("template");
        if (null == template) {
            return;
        }
        Set purlistCompSet = TemplateUtil.getPurListCompKeySet();
        HashSet<String> projectPurlistCompKeySet = new HashSet<String>(2);
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj, (boolean)false);
        for (String compKey : compKeyList) {
            if (!purlistCompSet.contains(compKey)) continue;
            projectPurlistCompKeySet.add(compKey);
        }
        if (projectPurlistCompKeySet.size() > 0 && null != (nodeRow = SrcBidCompTplUtil.getCurrNode(obj, "src_purlist", false))) {
            DynamicObject purlistTemplate = null;
            if (!(nodeRow.getDynamicObjectType() instanceof SubEntryType)) {
                return;
            }
            purlistTemplate = nodeRow.getDynamicObject("subcomptemplate");
            List purlistCompList = TemplateUtil.getCompKeyListByTemplate((DynamicObject)purlistTemplate);
            projectPurlistCompKeySet.removeAll(purlistCompList);
            if (projectPurlistCompKeySet.size() == 0) {
                return;
            }
            HashMap<String, DynamicObject> compEntryObjMap = new HashMap<String, DynamicObject>(projectPurlistCompKeySet.size());
            DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
            for (DynamicObject compEntryCol : compEntryCols) {
                DynamicObject currTemplate;
                String compKey;
                Object component = compEntryCol.get("tmp_bizobject");
                if (null == component || component.toString().trim().length() == 0 || !projectPurlistCompKeySet.contains(compKey = String.valueOf(component)) || null == (currTemplate = compEntryCol.getDynamicObject("tmp_template"))) continue;
                if (template.getPkValue().toString().equals(currTemplate.getPkValue().toString())) {
                    compEntryObjMap.put(compKey, compEntryCol);
                }
                if (purlistTemplate.getPkValue().toString().equals(currTemplate.getPkValue().toString())) {
                    projectPurlistCompKeySet.remove(compKey);
                }
                if (projectPurlistCompKeySet.size() != 0) continue;
                return;
            }
            this.addPurlistTplEntry(projectPurlistCompKeySet, purlistTemplate, compEntryObjMap);
        }
    }

    public void addPurlistTplEntry(Set<String> addCompKeySet, DynamicObject purlistTemplate, Map<String, DynamicObject> compEntryObjMap) {
        DynamicObject obj = this.getModel().getDataEntity(true);
        DynamicObjectCollection compEntryCols = obj.getDynamicObjectCollection("tplentry");
        boolean isNew = false;
        for (String compKey : addCompKeySet) {
            DynamicObject compEntry = compEntryObjMap.get(compKey);
            if (null == compEntry) continue;
            isNew = true;
            DynamicObject newEntry = compEntryCols.addNew();
            newEntry.set("tmp_template", (Object)purlistTemplate);
            newEntry.set("tmp_component", compEntry.get("tmp_component"));
            newEntry.set("tmp_bizobject", compEntry.get("tmp_bizobject"));
        }
        if (isNew) {
            DynamicObjectUtil.setBillEntrySeq((DynamicObject)obj, (String)"tplentry");
        }
    }

    public void setComponentStatus(BillShowParameter bs) {
        Set compKeySet;
        List compKeyList;
        String formId = bs.getFormId();
        Object billStatus = this.getModel().getValue("billstatus");
        if (null != billStatus && BillStatusEnum.SAVE.getVal().equals(billStatus.toString()) && !(compKeyList = TemplateUtil.getCompKeyList((DynamicObject)this.getModel().getDataEntity(true))).contains(formId) && (compKeySet = TemplateUtil.getPurListCompKeySet()).contains(formId)) {
            bs.setBillStatus(BillOperationStatus.SUBMIT);
            return;
        }
        super.setComponentStatus(bs);
    }

    public boolean isDoCompOperation(String operateKey, String entityKey, boolean isAttach) {
        DynamicObject template;
        List compKeyList;
        if (isAttach && (compKeyList = TemplateUtil.getCompKeyListByTemplate((DynamicObject)(template = this.getModel().getDataEntity().getDynamicObject("template")))).contains(entityKey)) {
            return true;
        }
        return super.isDoCompOperation(operateKey, entityKey, isAttach);
    }

    public boolean isNeedFilterEntityKey(String entityKey, String compKey) {
        return false;
    }

    public void reloadComponent(String targetPage, String compKey, boolean isPlain) {
        super.reloadComponent(targetPage, compKey, isPlain);
        IPageCache cache = this.getPageCache();
        cache.remove(compKey + "_" + "isTemplateChanged");
    }

    public void refreshComponetByDoOp(Map<String, String> reloadCompMap, String opKey, boolean existsFailOperation, boolean isPlain) {
        if (!existsFailOperation) {
            ArrayList<String> removeKeyList = new ArrayList<String>(4);
            for (Map.Entry<String, String> reloadCompEntry : reloadCompMap.entrySet()) {
                removeKeyList.add(reloadCompEntry.getKey() + "_" + "isTemplateChanged");
            }
            IPageCache cache = this.getPageCache();
            cache.batchRemove(removeKeyList);
        }
        super.refreshComponetByDoOp(reloadCompMap, opKey, existsFailOperation, isPlain);
    }
}

