/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.contract;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class SrcContractHasPushValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        DynamicObject projectObj;
        if (null == validatorData.getBillObj()) {
            return;
        }
        DynamicObject billObj = validatorData.getBillObj();
        Long projectId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        if ("src_bidchange".equals(billObj.getDataEntityType().getName()) && Objects.nonNull(projectObj = billObj.getDynamicObject("project"))) {
            projectId = projectObj.getLong("id");
        }
        QFilter projectFilter = new QFilter("billid", "=", (Object)projectId);
        QFilter contractFilter = new QFilter("contractqty", ">", (Object)BigDecimal.ZERO);
        contractFilter.or("contractamt", ">", (Object)BigDecimal.ZERO);
        contractFilter.or("contracttaxamt", ">", (Object)BigDecimal.ZERO);
        QFilter orderFilter = new QFilter("orderqty", ">", (Object)BigDecimal.ZERO);
        orderFilter.or("orderamt", ">", (Object)BigDecimal.ZERO);
        orderFilter.or("ordertaxamt", ">", (Object)BigDecimal.ZERO);
        QFilter pricelistFilter = new QFilter("pricelistno", "!=", (Object)"");
        pricelistFilter.or("pricelistid", "!=", (Object)"");
        QFilter sourcelistFilter = new QFilter("sourcelistno", "!=", (Object)"");
        sourcelistFilter.or("sourcelistid", "!=", (Object)"");
        QFilter protocolFilter = new QFilter("protocolqty", ">", (Object)BigDecimal.ZERO);
        QFilter qFilters = projectFilter.and(contractFilter.or(orderFilter).or(pricelistFilter).or(sourcelistFilter).or(protocolFilter));
        if (QueryServiceHelper.exists((String)"src_contractentry", (QFilter[])qFilters.toArray())) {
            validatorData.setSucced(false);
            validatorData.setMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u7ecf\u4e0b\u63a8\u91c7\u8d2d\u5408\u540c/\u91c7\u8d2d\u8ba2\u5355/\u4ef7\u76ee\u8868/\u8d27\u6e90\u6e05\u5355/\u534f\u8bae\u7b7e\u8ba2\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"SrcContractHasPushValidator_2", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }
}

