/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.contract;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsParameterUtils;
import kd.scm.src.common.contract.ISrcDecisonToContractHandler;

public class SrcDecisionContractHandlerAudit
implements ISrcDecisonToContractHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(ExtPluginContext context) {
        this.initContractCreator(context);
        this.createContractEntry(context);
    }

    private void initContractCreator(ExtPluginContext context) {
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getPkValue(), (String)"src_contract");
        contract.set("creator", (Object)RequestContext.get().getCurrUserId());
        contract.set("createtime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{contract});
    }

    protected void createContractEntry(ExtPluginContext context) {
        Set resultValueSet = PdsParameterUtils.getResultValueSet();
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj());
        QFilter qFilters = new QFilter("project.id", "=", (Object)projectId).and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue()).and("result", "in", (Object)resultValueSet);
        if (null != context.getPurlistIds() && context.getPurlistIds().size() > 0) {
            qFilters.and("purlist", "in", (Object)context.getPurlistIds());
        }
        qFilters.and("purlist", "not in", this.getContractPurlistIds(projectId));
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)true);
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qFilters.toArray());
        if (null == purlistObjs || purlistObjs.length == 0) {
            return;
        }
        ArrayList<DynamicObject> contractObjList = new ArrayList<DynamicObject>(purlistObjs.length);
        ArrayList<DynamicObject> tieredObjList = new ArrayList<DynamicObject>(purlistObjs.length * 4);
        String tieredFields = DynamicObjectUtil.getSelectfields((String)"src_purlist_tiered", (boolean)true);
        List propertys = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"src_contractentry"));
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject contractObj = BusinessDataServiceHelper.newDynamicObject((String)"src_contractentry");
            contractObj.set("id", purlistObj.getPkValue());
            this.setEntryValue(purlistObj, contractObj, propertys);
            this.recalculatePrice(contractObj);
            this.createTieredEntry(purlistObj, contractObj, tieredObjList, tieredFields);
            contractObj.set("billid", (Object)projectId);
            contractObjList.add(contractObj);
        }
        PdsCommonUtils.saveDynamicObjects(contractObjList);
        PdsCommonUtils.saveDynamicObjects(tieredObjList);
    }

    protected void createTieredEntry(DynamicObject purlistObj, DynamicObject contractObj, List<DynamicObject> tieredObjList, String tieredFields) {
        QFilter qfilter = new QFilter("entryid", "=", purlistObj.getPkValue());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlist_tiered", (String)tieredFields, (QFilter[])qfilter.toArray());
        if (null == rows || rows.size() == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObject tieredObj = BusinessDataServiceHelper.newDynamicObject((String)"src_contract_tiered");
            tieredObj.set("tieredqtyfrom", row.get("tieredqtyfrom"));
            tieredObj.set("tieredqtyto", row.get("tieredqtyto"));
            tieredObj.set("tieredprice", row.get("tieredprice"));
            tieredObj.set("tieredtaxprice", row.get("tieredtaxprice"));
            tieredObj.set("tierednote", row.get("tierednote"));
            tieredObj.set("tieredunit", row.get("tieredunit"));
            tieredObj.set("tieredcurr", row.get("tieredcurr"));
            tieredObj.set("tieredproject", row.get("tieredproject"));
            tieredObj.set("entryid", contractObj.getPkValue());
            tieredObjList.add(tieredObj);
        }
    }

    protected void setEntryValue(DynamicObject sourceObj, DynamicObject targetObj, List<String> propertys) {
        for (String property : propertys) {
            if ("entryid".equals(property)) continue;
            String fieldName = property.replace("entry_", "");
            try {
                if ("suppliernumber".equals(fieldName) || "bdsupplier".equals(fieldName)) continue;
                Object obj = sourceObj.get(fieldName);
                if (obj instanceof DynamicObject) {
                    if (Objects.equals(property, "supplier")) {
                        targetObj.set("suppliernumber", ((DynamicObject)obj).getPkValue());
                        targetObj.set("bdsupplier", ((DynamicObject)obj).getPkValue());
                    }
                    targetObj.set(property, ((DynamicObject)obj).getPkValue());
                    continue;
                }
                if (Objects.equals(property, "suppliername")) {
                    if (!StringUtils.isEmpty((Object)targetObj.getString("suppliername"))) continue;
                    targetObj.set(property, (Object)sourceObj.getString("supplier.name"));
                    continue;
                }
                targetObj.set(property, obj);
            }
            catch (Exception exception) {}
        }
    }

    protected void recalculatePrice(DynamicObject contractObj) {
        BigDecimal price_uom = contractObj.getBigDecimal("price_uom");
        if (price_uom.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        int priceprecision = contractObj.getInt("currency.priceprecision");
        if (priceprecision == 0) {
            priceprecision = 6;
        }
        contractObj.set("price", (Object)contractObj.getBigDecimal("price").divide(price_uom, priceprecision, RoundingMode.HALF_UP));
        contractObj.set("taxprice", (Object)contractObj.getBigDecimal("taxprice").divide(price_uom, priceprecision, RoundingMode.HALF_UP));
    }

    protected Set<Long> getContractPurlistIds(long projectId) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_contractentry", (String)"purlist.id", (QFilter[])qfilters.toArray());
        return rows.stream().map(e -> e.getLong("purlist.id")).collect(Collectors.toSet());
    }
}

