/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class SrcEvaluateTaskMsgToScorer
implements IEventServicePlugin {
    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        DynamicObject configObj = BusinessDataServiceHelper.loadSingle((String)"src_evaluateconfig", (String)"scorer", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)String.valueOf(billId))});
        DynamicObjectCollection rows = configObj.getDynamicObjectCollection("entryentity");
        HashSet userIds = new HashSet(16);
        rows.forEach(row -> {
            DynamicObjectCollection scorers = row.getDynamicObjectCollection("scorer");
            userIds.addAll(scorers.stream().map(scorer -> scorer.getLong("fbasedataid.id")).collect(Collectors.toList()));
        });
        userIdMaps.put(billId, new ArrayList(userIds));
        return userIdMaps;
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        DynamicObject evaluateTaskObj = BusinessDataServiceHelper.loadSingle((String)"src_myevaluatetask", (String)"id", (QFilter[])new QFilter[]{new QFilter("project", "=", (Object)Long.parseLong(billId))});
        long evaluateTaskId = evaluateTaskObj.getLong("id");
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        StringBuilder url = new StringBuilder();
        String domainContextUrl = UrlService.getDomainContextUrl();
        url.append(domainContextUrl);
        url.append("?formId=bos_list");
        url.append("&type=list");
        url.append("&billFormId=");
        url.append("src_myevaluatetask");
        url.append("&pkId=");
        url.append(evaluateTaskId);
        String accountId = RequestContext.get().getAccountId();
        url.append("&accountId=");
        url.append(accountId);
        urlMaps.put(billId, url.toString());
        return urlMaps;
    }
}

