/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.pds.common.util.PdsUrlUtil;

public class SrcNoticeSendMsgToSup
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(SrcNoticeSendMsgToSup.class);

    public String buildUrl(KDBizEvent evt) {
        long projectId;
        StringBuilder url = new StringBuilder();
        String source = evt.getSource();
        String srcbillid = this.parseSrcBillId(source);
        if (StringUtils.isNotEmpty((CharSequence)srcbillid) && (projectId = Long.parseLong(srcbillid)) != 0L) {
            url.append(PdsUrlUtil.getUrl((String)"tnd_project", (Object)projectId));
        }
        return url.toString();
    }

    public List<Long> calcUserIds(KDBizEvent evt) {
        DynamicObject[] srcBidOpenSupDyns;
        String source = evt.getSource();
        ArrayList<Long> userIds = new ArrayList<Long>(1024);
        HashSet<Long> bizpartnerIds = new HashSet<Long>(1024);
        HashSet<Long> specialSupUserIds = new HashSet<Long>(1024);
        String srcbillid = this.parseSrcBillId(source);
        DynamicObjectCollection pdsNoticeDyns = QueryServiceHelper.query((String)"pds_noticesupplier", (String)"id,supplierentry.issend,supplierentry.supplier", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", (Object)srcbillid).and("srcbilltype", "=", (Object)"src_decision")});
        for (DynamicObject[] pdsNoticeDyn : pdsNoticeDyns) {
            boolean isSend = pdsNoticeDyn.getBoolean("supplierentry.issend");
            if (!isSend) continue;
            long supplier = pdsNoticeDyn.getLong("supplierentry.supplier");
            Long bizPartnerId = BizPartnerUtil.getBizPartnerBySupplier((Object)supplier);
            bizpartnerIds.add(bizPartnerId);
        }
        userIds.addAll(BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizpartnerIds));
        log.info("administrator user ids: " + userIds);
        for (DynamicObject srcBidOpenSupDyn : srcBidOpenSupDyns = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)"id,billid,supplier,supplieruser", (QFilter[])new QFilter[]{new QFilter("billid.id", "=", (Object)Long.parseLong(srcbillid))})) {
            DynamicObjectCollection supUserDyns = srcBidOpenSupDyn.getDynamicObjectCollection("supplieruser");
            if (supUserDyns == null || supUserDyns.isEmpty()) continue;
            for (DynamicObject supUserDyn : supUserDyns) {
                long supUserId = supUserDyn.getDynamicObject("fbasedataid").getLong("id");
                specialSupUserIds.add(supUserId);
            }
        }
        if (!specialSupUserIds.isEmpty()) {
            DynamicObjectCollection specialUserDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("id", "in", specialSupUserIds)});
            for (DynamicObject specialUserDyn : specialUserDyns) {
                long user = specialUserDyn.getLong("user");
                userIds.add(user);
            }
        }
        log.info("receive user id: " + userIds);
        return userIds;
    }

    private String parseSrcBillId(String source) {
        String srcbillid = "";
        JSONArray array = JSONArray.parseArray((String)source);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            srcbillid = jsonObject.getString("srcbillid");
        }
        return srcbillid;
    }
}

