/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsUrlUtil;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcProjectSendMsgToSup
implements IEventServicePlugin {
    private static final Log log = LogFactory.getLog(SrcProjectSendMsgToSup.class);

    public String buildUrl(KDBizEvent evt) {
        StringBuilder url = new StringBuilder();
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        if (StringUtils.isNotEmpty((CharSequence)businesskey)) {
            String source = evt.getSource();
            long projectId = Long.parseLong(businesskey);
            JSONArray sourceArray = JSONArray.parseArray((String)source);
            if (Objects.nonNull(sourceArray)) {
                for (int i = 0; i < sourceArray.size(); ++i) {
                    JSONObject jsonObject = sourceArray.getJSONObject(i);
                    if (!jsonObject.containsKey((Object)"project") || !((EntityEvent)evt).getEntityNumber().equals("pds_bizoperatelog")) continue;
                    JSONObject projectDyn = jsonObject.getJSONObject("project");
                    projectId = projectDyn.getLong("id");
                }
            }
            if (projectId != 0L) {
                url.append(PdsUrlUtil.getUrl((String)"tnd_project", (Object)projectId));
            }
        }
        return url.toString();
    }

    public List<Long> calcUserIds(KDBizEvent evt) {
        ArrayList<Long> userIds = new ArrayList<Long>(1024);
        HashSet<Long> bizpartnerIds = new HashSet<Long>(1024);
        HashSet specialSupUserIds = new HashSet(1024);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        HashMap<Long, Set<Long>> supplierMap = new HashMap<Long, Set<Long>>(16);
        String source = evt.getSource();
        Long orgId = null;
        JSONArray sourceArray = JSONArray.parseArray((String)source);
        for (int i = 0; i < sourceArray.size(); ++i) {
            JSONObject jSONObject = sourceArray.getJSONObject(i);
            if (jSONObject.containsKey((Object)"projectf7")) {
                orgId = jSONObject.getJSONObject("projectf7").getJSONObject("org").getLong("id");
                continue;
            }
            if (jSONObject.containsKey((Object)"project") && ((EntityEvent)evt).getEntityNumber().equals("pds_bizoperatelog")) {
                JSONObject projectDyn = jSONObject.getJSONObject("project");
                billId = projectDyn.getLong("id").toString();
                orgId = jSONObject.getJSONObject("project").getJSONObject("org").getLong("id");
                continue;
            }
            JSONObject orgDyn = jSONObject.getJSONObject("org");
            orgId = orgDyn.getLong("id");
        }
        this.getInviteSupplier(billId, supplierMap);
        this.getItemSupplier(billId, supplierMap);
        this.getConfirmPriceSupplier(billId, supplierMap);
        if (CollectionUtils.isEmpty(supplierMap)) {
            return userIds;
        }
        for (Map.Entry entry : supplierMap.entrySet()) {
            bizpartnerIds.add(BizPartnerUtil.getBizPartnerBySupplier(entry.getKey()));
            specialSupUserIds.addAll((Collection)entry.getValue());
        }
        if (!specialSupUserIds.isEmpty()) {
            DynamicObjectCollection specialUserDyns = QueryServiceHelper.query((String)"pur_supuser", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("id", "in", specialSupUserIds).and(new QFilter("enable", "=", (Object)"1"))});
            for (DynamicObject specialUserDyn : specialUserDyns) {
                long user = specialUserDyn.getLong("user");
                userIds.add(user);
            }
        }
        log.info("supplier user ids: " + userIds);
        userIds.addAll(BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizpartnerIds));
        log.info("administrator user id: " + userIds);
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)l, null, (String)"tnd_project", (String)"47150e89000000ac");
            List permOrgs = hasPermOrgResult.getHasPermOrgs();
            if (permOrgs.contains(orgId)) continue;
            iterator.remove();
        }
        log.info("receive user id: " + userIds);
        return userIds;
    }

    private void getInviteSupplier(String billId, Map<Long, Set<Long>> supplierMap) {
        DynamicObject inviteSupplier = TemplateUtil.getComponentData((Object)billId, (String)"src_project", (String)"src_supplier_invite");
        if (Objects.isNull(inviteSupplier)) {
            return;
        }
        DynamicObjectCollection rows = inviteSupplier.getDynamicObjectCollection("entrysupplier");
        for (DynamicObject row : rows) {
            long supplierId = row.getLong("supplier.id");
            if (supplierId == 0L) continue;
            DynamicObjectCollection users = row.getDynamicObjectCollection("supplieruser");
            supplierMap.put(supplierId, users.stream().map(user -> user.getLong("fbasedataid.id")).collect(Collectors.toSet()));
        }
    }

    private void getItemSupplier(String billId, Map<Long, Set<Long>> supplierMap) {
        DynamicObject itemSupplier = TemplateUtil.getComponentData((Object)billId, (String)"src_project", (String)"src_itemsupplier");
        if (Objects.isNull(itemSupplier)) {
            return;
        }
        DynamicObjectCollection itemSupCols = itemSupplier.getDynamicObjectCollection("entryentity");
        for (DynamicObject itemSupCol : itemSupCols) {
            DynamicObjectCollection supCols = itemSupCol.getDynamicObjectCollection("supplier");
            supCols.forEach(supCol -> supplierMap.put(supCol.getLong("fbasedataid.id"), Collections.emptySet()));
        }
    }

    private void getConfirmPriceSupplier(String billId, Map<Long, Set<Long>> supplierMap) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(billId), (String)"src_project");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)obj.getDynamicObject("supplier"));
        if (supplierId == 0L) {
            return;
        }
        DynamicObjectCollection users = obj.getDynamicObjectCollection("supplieruser");
        supplierMap.put(supplierId, users.stream().map(user -> user.getLong("fbasedataid.id")).collect(Collectors.toSet()));
    }
}

