/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.expertchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.expertchange.SrcExpertChangeUtils;

public class SrcExpertChangeEntryCompare
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.compareEntryDataDiff(context);
    }

    public void compareEntryDataDiff(ExtPluginContext context) {
        ArrayList<Map<String, Object>> changeList = new ArrayList<Map<String, Object>>(32);
        for (String entityKey : context.getEntryKeys()) {
            String[] entityKeys = entityKey.split("\\|");
            String entryIdField = entityKeys[0] + '_' + "entryid";
            DynamicObjectCollection oldRows = context.getProjectObj().getDynamicObjectCollection(entityKeys[0]);
            DynamicObjectCollection newRows = context.getBillObj().getDynamicObjectCollection(entityKeys[0]);
            if (oldRows.size() == 0 && newRows.size() == 0) continue;
            List<String> properties = null;
            HashMap<Long, DynamicObject> oldMap = new HashMap();
            if (oldRows.size() > 0) {
                oldMap = oldRows.stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
                properties = SrcExpertChangeUtils.getEntryProperties((DynamicObject)oldRows.get(0));
            }
            HashMap<Long, DynamicObject> newMap = new HashMap();
            if (newRows.size() > 0) {
                newMap = newRows.stream().collect(Collectors.groupingBy(e -> e.getLong(entryIdField) > 0L ? e.getLong(entryIdField) : e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
                if (null == properties) {
                    properties = SrcExpertChangeUtils.getEntryProperties((DynamicObject)newRows.get(0));
                }
            }
            HashSet<Long> processIdSet = new HashSet<Long>(oldRows.size() + newRows.size());
            List<Long> oldEntryIdList = this.getEntryIdList(oldRows, null);
            for (long entryId : oldEntryIdList) {
                if (!processIdSet.add(entryId)) continue;
                this.compareEntryFieldValue(context, entryId, oldMap, newMap, properties, entityKeys, changeList);
            }
            List<Long> newEntryIdList = this.getEntryIdList(newRows, entryIdField);
            for (long entryId : newEntryIdList) {
                if (!processIdSet.add(entryId)) continue;
                this.compareEntryFieldValue(context, entryId, oldMap, newMap, properties, entityKeys, changeList);
            }
        }
        context.setAttachList(changeList);
    }

    public List<Long> getEntryIdList(DynamicObjectCollection rows, String entryIdField) {
        ArrayList<Long> entryIds = new ArrayList<Long>(rows.size());
        for (DynamicObject row : rows) {
            long srcEntryId;
            long entryId = row.getLong("id");
            if (null != entryIdField && (srcEntryId = row.getLong(entryIdField)) > 0L) {
                entryId = srcEntryId;
            }
            entryIds.add(entryId);
        }
        return entryIds;
    }

    public void compareEntryFieldValue(ExtPluginContext context, long entryId, Map<Long, DynamicObject> oldMap, Map<Long, DynamicObject> newMap, List<String> properties, String[] entityKeys, List<Map<String, Object>> changeList) {
        DynamicObject newObj;
        DynamicObject oldObj = oldMap.get(entryId);
        List<Map<String, Object>> rowChangeList = SrcExpertChangeUtils.compareObjectDataDiff(context, oldObj, newObj = newMap.get(entryId), properties, context.getResultMap());
        if (null == rowChangeList || rowChangeList.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> rowChange : rowChangeList) {
            if (null == oldObj) {
                sb.append(rowChange.get("newvalue")).append(",");
                continue;
            }
            if (null == newObj) {
                sb.append(rowChange.get("oldvalue")).append(",");
                continue;
            }
            rowChange.put("entityname", entityKeys[1]);
            rowChange.put("fieldid", PdsCommonUtils.buildString((Object[])new Object[]{entityKeys[0], "|", rowChange.get("fieldid")}));
            rowChange.put("index", newObj.getInt("seq"));
        }
        if (null == oldObj) {
            HashMap<String, Object> addChange = new HashMap<String, Object>(8);
            addChange.put("changetype", "1");
            addChange.put("entityname", entityKeys[1]);
            addChange.put("fieldid", entityKeys[0]);
            addChange.put("fieldname", ResManager.loadKDString((String)"\u65b0\u589e\u5206\u5f55", (String)"SrcExpertChangeEntryCompare_3", (String)"scm-src-common", (Object[])new Object[0]));
            addChange.put("index", newObj.getInt("seq"));
            addChange.put("newvalue", sb.toString());
            changeList.add(addChange);
        } else if (null == newObj) {
            HashMap<String, Object> delChange = new HashMap<String, Object>(8);
            delChange.put("changetype", "2");
            delChange.put("entityname", entityKeys[1]);
            delChange.put("fieldid", entityKeys[0]);
            delChange.put("fieldname", ResManager.loadKDString((String)"\u5220\u9664\u5206\u5f55", (String)"SrcExpertChangeEntryCompare_4", (String)"scm-src-common", (Object[])new Object[0]));
            delChange.put("index", oldObj.getInt("seq"));
            delChange.put("oldvalue", sb.toString());
            changeList.add(delChange);
        } else {
            changeList.addAll(rowChangeList);
        }
    }
}

