/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcValidScorerHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        QFilter qFilter = this.getQFilter(context);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_scoreanalyse", (String)"scorer.id", (QFilter[])qFilter.toArray());
        if (rows.size() == 0) {
            return;
        }
        Set scorerIds = rows.stream().map(e -> e.getLong("scorer.id")).collect(Collectors.toSet());
        MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)context.getBillObj(), scorerIds, (String)"scorers");
        PdsCommonUtils.saveDynamicObjects((DynamicObject)context.getBillObj());
    }

    private QFilter getQFilter(ExtPluginContext context) {
        String entityName;
        QFilter qFilter = this.getBaseFilter(context);
        switch (entityName = context.getBillObj().getDataEntityType().getName()) {
            case "src_aptitudeaudit": {
                qFilter.and("billid.indextype.basetype", "=", (Object)"4");
                break;
            }
            case "src_aptitudeaudit2": {
                qFilter.and("billid.indextype.basetype", "=", (Object)"7");
                break;
            }
            case "src_bidassess": {
                qFilter.and("billid.indextype.basetype", "!=", (Object)"2");
                qFilter.and("billid.indextype.basetype", "!=", (Object)"4");
                qFilter.and("billid.indextype.basetype", "!=", (Object)"7");
                break;
            }
            case "src_compare": {
                qFilter.and("billid.indextype.basetype", "=", (Object)"2");
                break;
            }
            case "src_scorertask": 
            case "src_predecision": 
            case "src_decision": {
                qFilter.and("billid.indextype.basetype", "!=", (Object)"4");
                qFilter.and("billid.indextype.basetype", "!=", (Object)"7");
                break;
            }
        }
        return qFilter;
    }

    private QFilter getBaseFilter(ExtPluginContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
        qFilter.and("billid.bizstatus", "=", (Object)SrmScoreStatusEnum.SCORED.getValue());
        return qFilter;
    }
}

