/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.purlist;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCalculateUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcPurlistEntryEditHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        this.calcCfmQtyOrderRatio(context);
    }

    public void calcCfmQtyOrderRatio(ExtPluginContext context) {
        IFormView view = context.getView();
        DynamicObject row = context.getSourceRow();
        int rowIndex = context.getIndex();
        String fieldKey = context.getOperationKey();
        String subfix = this.getSubfix(view);
        String ratioType = this.getRatioType(view);
        DynamicObject unitObj = row.getDynamicObject("unit" + subfix);
        BigDecimal qty = row.getBigDecimal("qty" + subfix);
        BigDecimal cfmQty = row.getBigDecimal("cfmqty" + subfix);
        BigDecimal orderRatio = row.getBigDecimal("orderratio" + subfix);
        switch (fieldKey) {
            case "qty": 
            case "qty_new": {
                if ("9".equals(ratioType)) {
                    this.updateOrderRatio(view, rowIndex, unitObj, qty, cfmQty, orderRatio, subfix);
                    break;
                }
                this.updateCfmQty(view, rowIndex, unitObj, qty, cfmQty, orderRatio, subfix);
                break;
            }
            case "cfmqty": 
            case "cfmqty_new": {
                this.updateOrderRatio(view, rowIndex, unitObj, qty, cfmQty, orderRatio, subfix);
                break;
            }
            case "orderratio": 
            case "orderratio_new": {
                this.updateCfmQty(view, rowIndex, unitObj, qty, cfmQty, orderRatio, subfix);
                break;
            }
        }
    }

    private void updateOrderRatio(IFormView view, int rowIndex, DynamicObject unitObj, BigDecimal qty, BigDecimal cfmQty, BigDecimal orderratio, String subfix) {
        IDataModel model = view.getModel();
        BigDecimal hundred = new BigDecimal("100");
        orderratio = cfmQty.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(BigDecimal.ZERO) > 0 ? cfmQty.multiply(hundred).divide(qty, 2, RoundingMode.HALF_DOWN) : BigDecimal.ZERO;
        model.beginInit();
        model.setValue("orderratio" + subfix, (Object)orderratio, rowIndex);
        model.endInit();
        view.updateView("orderratio" + subfix, rowIndex);
    }

    private void updateCfmQty(IFormView view, int rowIndex, DynamicObject unitObj, BigDecimal qty, BigDecimal cfmQty, BigDecimal orderratio, String subfix) {
        IDataModel model = view.getModel();
        BigDecimal hundred = new BigDecimal("100");
        cfmQty = orderratio.compareTo(BigDecimal.ZERO) > 0 && qty.compareTo(BigDecimal.ZERO) > 0 ? PdsCalculateUtils.setScaleByUnit((DynamicObject)unitObj, (BigDecimal)orderratio.multiply(qty).divide(hundred)) : BigDecimal.ZERO;
        model.beginInit();
        model.setValue("cfmqty" + subfix, (Object)cfmQty, rowIndex);
        model.endInit();
        view.updateView("cfmqty" + subfix, rowIndex);
    }

    private String getSubfix(IFormView view) {
        return "src_decisionchg".equals(view.getEntityId()) ? "_new" : "";
    }

    private String getRatioType(IFormView view) {
        DynamicObject projectObj = null;
        DynamicObject billObj = view.getModel().getDataEntity();
        if (null != billObj.getDynamicObjectType().getProperty("projectf7")) {
            projectObj = billObj.getDynamicObject("projectf7");
        } else if (null != billObj.getDynamicObjectType().getProperty("project")) {
            projectObj = billObj.getDynamicObject("project");
        }
        return null == projectObj ? "1" : PdsCommonUtils.object2String((Object)projectObj.get("ratiotype"), (String)"1");
    }
}

