/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.extplugin.srcoreassist;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.src.common.util.SrcScoreBySupUtil;

public class SrcScoreBySupOpPlugin
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        String opKey;
        switch (opKey = context.getAfterDoOperationEventArgs().getOperateKey()) {
            case "save": 
            case "submit": {
                String uniqueKey;
                Map<String, String> supMap = this.getSupMap(context);
                if (null == supMap) {
                    return;
                }
                DynamicObject scoreAssitObj = context.getView().getModel().getDataEntity(true);
                DynamicObjectCollection scoreEntryCols = scoreAssitObj.getDynamicObjectCollection("score_entry");
                if (scoreEntryCols.size() == 0) {
                    return;
                }
                Map fitIndexMap = (Map)context.getView().getFormShowParameter().getCustomParam("isfitted");
                HashMap<String, Boolean> supFitDataMap = new HashMap<String, Boolean>(8);
                HashMap<String, String> supValDataMap = new HashMap<String, String>(8);
                for (DynamicObject scoreEntry : scoreEntryCols) {
                    Iterator<Map.Entry<String, String>> supObj;
                    Long indexId = scoreEntry.getLong("indexid");
                    boolean isfitted = false;
                    if (Objects.nonNull(fitIndexMap) && Objects.nonNull(supObj = fitIndexMap.get(String.valueOf(indexId)))) {
                        isfitted = true;
                    }
                    supObj = supMap.entrySet().iterator();
                    while (supObj.hasNext()) {
                        Map.Entry<String, String> supEntry = supObj.next();
                        uniqueKey = SrcScoreBySupUtil.getRowGroupKey(scoreEntry, supEntry.getKey());
                        if (isfitted) {
                            boolean isfit = scoreEntry.getBoolean(SrcScoreBySupUtil.getCheckBoxKey(supEntry.getKey()));
                            supFitDataMap.put(uniqueKey, isfit);
                            continue;
                        }
                        String inputVal = scoreEntry.getString(SrcScoreBySupUtil.getTextKey(supEntry.getKey()));
                        if (StringUtils.isEmpty((String)inputVal)) continue;
                        supValDataMap.put(uniqueKey, inputVal);
                    }
                }
                IFormView parentView = context.getView().getParentView();
                if (null == parentView) {
                    return;
                }
                IDataModel pModel = parentView.getModel();
                DynamicObjectCollection pScoreEntryCols = pModel.getEntryEntity("score_entry");
                for (int i = 0; i < pScoreEntryCols.size(); ++i) {
                    String bizStatus = ((DynamicObject)pScoreEntryCols.get(i)).getString("bizstatus");
                    if (bizStatus.compareTo("D") >= 0) continue;
                    DynamicObject supplier = ((DynamicObject)pScoreEntryCols.get(i)).getDynamicObject("supplier");
                    uniqueKey = SrcScoreBySupUtil.getRowGroupKey((DynamicObject)pScoreEntryCols.get(i), supplier.getPkValue());
                    Object inputVal = supValDataMap.get(uniqueKey);
                    if (Objects.isNull(inputVal)) {
                        Object fitObj = supFitDataMap.get(uniqueKey);
                        if (null != fitObj && !((Boolean)fitObj).booleanValue()) {
                            pModel.setValue("value", (Object)"0", i);
                            pModel.setValue("note", (Object)ResManager.loadKDString((String)"\u4e0d\u5408\u683c", (String)"SrcScoreBySupOpPlugin_0", (String)"scm-src-common", (Object[])new Object[0]), i);
                            pModel.setValue("scorerscored", (Object)"1", i);
                        }
                        pModel.setValue("isfitted", supFitDataMap.get(uniqueKey), i);
                        continue;
                    }
                    pModel.setValue("value", inputVal, i);
                }
                parentView.updateView("score_entry");
                context.getView().sendFormAction(parentView);
                this.doSaveOrSubmit(context);
                context.getView().close();
                break;
            }
        }
    }

    public void doSaveOrSubmit(ExtPluginContext context) {
        IFormView parentView = context.getView().getParentView();
        String opKey = context.getAfterDoOperationEventArgs().getOperateKey();
        if ("submit".equals(opKey)) {
            String parentPageId = context.getView().getParentView().getParentView().getPageId();
            if ("src_apphome".equals(context.getView().getParentView().getParentView().getEntityId())) {
                parentPageId = null;
            }
            parentView.invokeOperation("submit");
            context.getView().sendFormAction(parentView);
            QFilter qfilter = new QFilter("project", "=", (Object)context.getView().getModel().getDataEntity().getLong("project.id"));
            OpenFormUtils.openListPage((IFormView)context.getView(), (String)"src_memberclarify", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilter, null, (String)parentPageId);
        } else {
            parentView.invokeOperation("save");
        }
    }

    private Map<String, String> getSupMap(ExtPluginContext context) {
        Map<String, String> supMap = new HashMap<String, String>(8);
        IFormView view = context.getView();
        Object supObject = view.getFormShowParameter().getCustomParam("supplier");
        if (supObject instanceof Map) {
            supMap = (Map)supObject;
        }
        return supMap;
    }
}

