/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.hyperlink;

import java.util.HashMap;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.costdetail.PdsCostDetailCreateBill;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsCostDetailUtils;

public class SrcPurListHyperlinkCostDetail
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        switch (context.getHyperLinkClickEvent().getFieldName()) {
            case "costdetail": {
                this.hyperlinkHandle(context);
                break;
            }
        }
    }

    protected void hyperlinkHandle(ExtPluginContext context) {
        this.getCostDetailBillId(context);
        if (!context.isSucced()) {
            return;
        }
        this.allowSetCostDetail(context);
        if (!context.isSucced()) {
            return;
        }
        this.getCostDetailEntityId(context);
        this.createCostDetailBill(context);
        this.openCostDetailBill(context);
    }

    protected void getCostDetailBillId(ExtPluginContext context) {
        int index = context.getHyperLinkClickEvent().getRowIndex();
        DynamicObject row = context.getView().getModel().getEntryRowEntity("entryentity", index);
        long billId = PdsCommonUtils.object2Long((Object)row.getPkValue());
        if (billId == 0L) {
            billId = row.getLong("srcentryid");
        }
        if (billId == 0L) {
            context.setSucced(false);
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u540e\u518d\u7ef4\u62a4\u6210\u672c\u660e\u7ec6\u3002", (String)"SrcPurListHyperlinkCostDetail_4", (String)"scm-src-common", (Object[])new Object[0]));
        }
        context.setBillId(billId);
        this.resetNegCostDetailBillId(context);
    }

    protected void resetNegCostDetailBillId(ExtPluginContext context) {
        context.setPentitykey(null == context.getView().getParentView() ? "" : context.getView().getParentView().getEntityId());
        if (!"src_negotiatebill".equals(context.getPentitykey())) {
            return;
        }
        QFilter purlistFilter = new QFilter("project", "=", (Object)context.getView().getParentView().getModel().getDataEntity().getLong("project.id")).and("srcentryid", "=", (Object)String.valueOf(context.getBillId()));
        DynamicObject purlistObj = QueryServiceHelper.queryOne((String)"src_purlistf7", (String)"id", (QFilter[])purlistFilter.toArray());
        if (null == purlistObj) {
            return;
        }
        QFilter costDetailFilter = new QFilter("id", "=", (Object)purlistObj.getLong("id"));
        if (!QueryServiceHelper.exists((String)"tnd_costdetail", (QFilter[])costDetailFilter.toArray())) {
            return;
        }
        context.setEntityId("tnd_costdetail");
        context.setBillId(purlistObj.getLong("id"));
    }

    protected void allowSetCostDetail(ExtPluginContext context) {
        int index = context.getHyperLinkClickEvent().getRowIndex();
        DynamicObject row = context.getView().getModel().getEntryRowEntity("entryentity", index);
        boolean isOffline = false;
        IFormView currentView = context.getView().getParentView();
        if ("src_contract".equals(context.getView().getEntityId())) {
            currentView = context.getView();
        }
        if ("tnd_vie_online".equals(context.getView().getEntityId())) {
            return;
        }
        isOffline = PdsCommonUtils.getNotProjectBill().contains(currentView.getEntityId()) ? currentView.getModel().getDataEntity().getString("project.sourceclass.number").equals("C011402") : currentView.getModel().getDataEntity().getString("sourceclass.number").equals("C011402");
        if ("0".equals(row.getString("costdetail")) && !isOffline && !PdsCostDetailUtils.allowSetCostDetailEntitys().contains(currentView.getEntityId())) {
            context.setSucced(false);
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6807\u7684\u672a\u7ef4\u62a4\u6210\u672c\u660e\u7ec6\u3002", (String)"SrcPurListHyperlinkCostDetail_5", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }

    protected void getCostDetailEntityId(ExtPluginContext context) {
        if (context.getEntityId() != null) {
            return;
        }
        String entityId = "src_costdetail";
        if ("tnd_vie_online".equals(context.getView().getEntityId()) || "src_vie_online".equals(context.getView().getEntityId())) {
            entityId = "tnd_costdetail";
        } else if (!context.getView().getEntityId().equals("src_contract") && !context.getView().getModel().getDataEntity().getBoolean("issrc")) {
            entityId = "tnd_costdetail";
        }
        context.setEntityId(entityId);
    }

    protected void createCostDetailBill(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)PdsCostDetailCreateBill.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    protected void openCostDetailBill(ExtPluginContext context) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        IFormView parentView = context.getView().getParentView();
        String entityId = context.getView().getEntityId();
        if (entityId.equals("src_contract") || entityId.equals("src_vie_online")) {
            paramMap.put("pentitykey", entityId);
        } else if (null != parentView) {
            paramMap.put("pentitykey", parentView.getEntityId());
        }
        paramMap.put("billid", context.getBillId());
        paramMap.put("index", context.getHyperLinkClickEvent().getRowIndex());
        boolean isView = false;
        if (entityId.equals("src_vie_online")) {
            isView = true;
        } else if (entityId.equals("tnd_vie_online") && !"C".equals(context.getView().getModel().getDataEntity().getString("bidstatusval"))) {
            isView = true;
        }
        if (isView) {
            paramMap.put("view", true);
            OpenFormUtils.openBillPage((IFormView)context.getView(), (String)context.getEntityId(), (Object)context.getBillId(), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, paramMap, null);
        } else {
            OpenFormUtils.openBillPage((IFormView)context.getView(), (String)context.getEntityId(), (Object)context.getBillId(), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.MainNewTabPage, paramMap, null);
        }
    }
}

