/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.openhandle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;

public class SrcOtherPurlistHandler
implements ISrcNegOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        this.closeOtherPurlists(context);
    }

    protected void closeOtherPurlists(SrcNegOpenContext context) {
        List<DynamicObject> rows = this.getOtherPurlists(context);
        if (null == rows || rows.size() == 0) {
            return;
        }
        Set<String> quoteSupplier_purlist = this.getQuoteSupplier_purlist(context);
        ArrayList<DynamicObject> otherPurlistList = new ArrayList<DynamicObject>();
        for (String supplier_purlist : context.getSupplier_purlistSet()) {
            if (!context.isOffline() && !quoteSupplier_purlist.contains(supplier_purlist)) continue;
            String[] splits = supplier_purlist.split("\\_");
            long supplierId = Long.parseLong(splits[0]);
            long purlistId = Long.parseLong(splits[1]);
            List otherPurlistRows = rows.stream().filter(e -> e.getLong("supplier.id") == supplierId && e.getLong("purlist.id") == purlistId).collect(Collectors.toList());
            if (otherPurlistRows == null || otherPurlistRows.size() <= 0) continue;
            for (DynamicObject otherPurlistRow : otherPurlistRows) {
                otherPurlistRow.set("entrystatus", (Object)ProjectStatusEnums.CLOSED.getValue());
                otherPurlistList.add(otherPurlistRow);
            }
        }
        PdsCommonUtils.saveDynamicObjects(otherPurlistList);
    }

    protected List<DynamicObject> getOtherPurlists(SrcNegOpenContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("turns", "!=", (Object)context.getTurns());
        qfilter.and("entrystatus", "=", (Object)ProjectStatusEnums.OPENED.getValue());
        qfilter.and("supplier", "in", context.getSupplierIds());
        qfilter.and("purlist", "in", context.getPurlistIds());
        qfilter.and("id", "not in", context.getNegEntryIds());
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"suppliertype,supplier,purlist,entrystatus", (QFilter[])qfilter.toArray());
        return Arrays.asList(rows);
    }

    private Set<String> getQuoteSupplier_purlist(SrcNegOpenContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("turns", "=", (Object)context.getTurns());
        qfilter.and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        qfilter.and("id", "not in", context.getNegEntryIds());
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistf7", (String)"suppliertype,supplier.id,purlist.id", (QFilter[])qfilter.toArray());
        return rows.stream().map(e -> e.getString("supplier.id") + '_' + e.getString("purlist.id")).collect(Collectors.toSet());
    }
}

