/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.negopen.openhandle;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.negopen.ISrcNegOpenHandler;
import kd.scm.src.common.negopen.SrcNegOpenContext;

public class SrcQuoteBillStatusHandler
implements ISrcNegOpenHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcNegOpenContext context) {
        this.updateQuoteBillStatus(context);
        this.updateQuoteEntryStatus(context);
    }

    protected void updateQuoteBillStatus(SrcNegOpenContext context) {
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId());
        quoteFilter.and("turns", "=", (Object)context.getTurns());
        quoteFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getVal());
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)"tnd_quotebill", (String)"billstatus,bizstatus,auditor,auditdate", (QFilter[])quoteFilter.toArray());
        if (null == billObjs || billObjs.length == 0) {
            return;
        }
        for (DynamicObject billObj : billObjs) {
            billObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
            billObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSED.getValue());
            billObj.set("auditor", (Object)RequestContext.get().getCurrUserId());
            billObj.set("auditdate", (Object)TimeServiceHelper.now());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])billObjs);
    }

    protected void updateQuoteEntryStatus(SrcNegOpenContext context) {
        QFilter quoteFilter = new QFilter("project", "=", (Object)context.getProjectId());
        quoteFilter.and("turns", "=", (Object)context.getTurns());
        quoteFilter.and("entrystatus", "=", (Object)ProjectStatusEnums.QUOTED.getValue());
        quoteFilter.and("supplier", "in", context.getSupplierIds());
        quoteFilter.and("entryid", "not in", context.getNegEntryIds());
        DynamicObject[] purlistRows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"entrystatus", (QFilter[])quoteFilter.toArray());
        if (purlistRows != null && purlistRows.length > 0) {
            for (DynamicObject purlistRow : purlistRows) {
                purlistRow.set("entrystatus", (Object)ProjectStatusEnums.OPENED.getValue());
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])purlistRows);
        }
    }
}

