/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.pushproject;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsBOTPUtils;
import kd.scm.src.common.pushproject.ISrcPushProject;
import kd.scm.src.common.pushproject.ISrcPushPurlist;
import kd.scm.src.common.pushproject.SrcApplyAuditPushProject;
import kd.scm.src.common.pushproject.SrcApplyInitBotpParam;
import kd.scm.src.common.pushproject.SrcApplyPushProjectGetQFilter;
import kd.scm.src.common.pushproject.SrcApplyPushSetDefaultValue;
import kd.scm.src.common.pushproject.SrcApplyToProjectAfterTips;
import kd.scm.src.common.pushproject.SrcDemandInitBotpParam;
import kd.scm.src.common.pushproject.SrcDemandPushProjectGetQFilter;
import kd.scm.src.common.pushproject.SrcDemandPushSetDefaultValue;
import kd.scm.src.common.pushproject.SrcDemandToProjectAfterTips;

public class SrcPushProjectUtils {
    public static void pushProject(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)ISrcPushProject.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        if (!context.isSucced()) {
            return;
        }
        for (DynamicObject targetObj : context.getTargetObjs()) {
            context.setTargetObj(targetObj);
            context.setProjectObj((DynamicObject)context.getObjMap().get(targetObj.getLong("id")));
            context.setBillObj((DynamicObject)context.getObjMap2().get(targetObj.getLong("id")));
            ExtPluginFactory.executeExtplugin((String)ISrcPushPurlist.class.getSimpleName(), (ExtPluginContext)context, (boolean)false);
        }
    }

    public static DynamicObject getSourceFlowObj(DynamicObject targetObj) {
        long flowId = targetObj.getLong("srctype.id");
        return BusinessDataServiceHelper.loadSingle((Object)flowId, (String)"pds_flowconfig");
    }

    public static void setResultMessage(ExtPluginContext context) {
        StringBuilder sb = new StringBuilder();
        if (null == context.getMessage() || context.getMessage().length() == 0) {
            sb = sb.append(String.format(ResManager.loadKDString((String)"\u5bfb\u6e90\u9879\u76ee\u7f16\u53f7\uff1a%1$s\u3002", (String)"SrcPushProjectUtils_0", (String)"scm-src-common", (Object[])new Object[0]), context.getProjectObj().getString("billno")));
        } else {
            sb.append(context.getProjectObj().getString("billno"));
        }
        context.setMessage(sb);
    }

    public static Set<Long> getSrcBillIdsByBotpLink(ExtPluginContext context) {
        Set entryIds = PdsBOTPUtils.getSrcEntryIdsByBotpLink((DynamicObject)context.getTargetObj());
        QFilter qfilter = new QFilter("id", "in", (Object)entryIds);
        String billIdField = "src_demandf7two".equals(context.getSourceBill()) ? "source" : "billid";
        DynamicObjectCollection rows = QueryServiceHelper.query((String)context.getSourceBill(), (String)billIdField, (QFilter[])qfilter.toArray());
        return rows.stream().map(e -> e.getLong(billIdField)).collect(Collectors.toSet());
    }

    public static void applyInitBotpParam(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcApplyInitBotpParam.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcApplyInitBotpParam.class.getName());
    }

    public static void applySetDefaultValue(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcApplyPushSetDefaultValue.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcApplyPushSetDefaultValue.class.getName());
    }

    public static void demandInitBotpParam(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcDemandInitBotpParam.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcDemandInitBotpParam.class.getName());
    }

    public static void demandSetDefaultValue(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcDemandPushSetDefaultValue.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcDemandPushSetDefaultValue.class.getName());
    }

    public static void showTipsAfterApplyAudit(IFormView view, AfterDoOperationEventArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        context.setAfterDoOperationEventArgs(args);
        ExtPluginFactory.executeExtplugin((String)SrcApplyToProjectAfterTips.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public static void showTipsAfterDemandAudit(IFormView view, AfterDoOperationEventArgs args) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        context.setAfterDoOperationEventArgs(args);
        ExtPluginFactory.executeExtplugin((String)SrcDemandToProjectAfterTips.class.getSimpleName(), (ExtPluginContext)context, (boolean)true);
    }

    public static QFilter getApplyQFilter(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcApplyPushProjectGetQFilter.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcApplyPushProjectGetQFilter.class.getName());
        return context.getQfilters();
    }

    public static QFilter getDemandQFilter(ExtPluginContext context) {
        ExtPluginFactory.executeExtplugin((String)SrcDemandPushProjectGetQFilter.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcDemandPushProjectGetQFilter.class.getName());
        return context.getQfilters();
    }

    public static void applyManualPushProject(IFormView view) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        context.setBillObj(view.getModel().getDataEntity(true));
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        context.setOperationKey("pushproject");
        context.setHandleOk(false);
        ExtPluginFactory.executeExtplugin((String)SrcApplyAuditPushProject.class.getSimpleName(), (ExtPluginContext)context, (boolean)false, (String)SrcApplyAuditPushProject.class.getName());
    }
}

