/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.pushproject;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcPushPurlistWriteBack
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        if (!context.isSucced()) {
            return;
        }
        this.updateEntryStatus(context);
        this.updateSceneStatus(context);
        this.updateApplyItemStatus(context);
    }

    public void updateEntryStatus(ExtPluginContext context) {
        DynamicObject[] rows = context.getRows();
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            if (context.getSourceBill().equals("src_detail")) {
                row.set("demandstatus", (Object)"B");
                row.set("demandqty", row.get("qty"));
            }
            row.set("project", context.getProjectObj().getPkValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public void updateSceneStatus(ExtPluginContext context) {
        if (!context.getSourceBill().equals("src_demandf7two")) {
            return;
        }
        Map<Long, DynamicObject> sceneMap = Arrays.asList(context.getRows()).stream().collect(Collectors.groupingBy(e -> e.getLong("scene.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        QFilter qfilter = new QFilter("id", "in", sceneMap.keySet());
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_demandscene", (String)"scenestatus,projectno,project", (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObject purlistObj = sceneMap.get(row.getLong("id"));
            if (null == purlistObj) continue;
            row.set("scenestatus", (Object)"B");
            row.set("projectno", (Object)context.getProjectObj().getString("billno"));
            row.set("project", (Object)context.getProjectObj().getLong("id"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    public void updateApplyItemStatus(ExtPluginContext context) {
        if (!context.getSourceBill().equals("src_demandf7two")) {
            return;
        }
        if (null == context.getRows() || !"1".equals(context.getRows()[0].getString("reqsource11"))) {
            return;
        }
        Map<Long, DynamicObject> applyMap = null;
        applyMap = Arrays.asList(context.getRows()).stream().collect(Collectors.groupingBy(e -> e.getLong("srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        if (null == applyMap) {
            return;
        }
        QFilter qfilter = new QFilter("id", "in", applyMap.keySet());
        qfilter.and("billid.isproject", "=", (Object)"0");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_detail", (String)"billid,demandstatus,demandqty,qty,project", (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            DynamicObject purlistObj = applyMap.get(row.getLong("id"));
            if (null == purlistObj) continue;
            row.set("project", (Object)context.getProjectObj().getLong("id"));
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

