/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question.clarify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.question.IPdsQuestionHandler;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class SrcQuestionPriceClarifyHandler
implements IPdsQuestionHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsQuestionContext context) {
        if (context.getView().getModel().getDataEntity().getBoolean("isclarify")) {
            this.createSupplierClarify(context);
        }
    }

    public void createSupplierClarify(PdsQuestionContext context) {
        Map<Long, List<DynamicObject>> purlistMap = this.getPurlistMap(context);
        if (null == purlistMap) {
            context.setSucced(false);
            context.setMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fdb\u884c\u4ef7\u683c\u6f84\u6e05\u7684\u4f9b\u5e94\u5546\u53ca\u6807\u7684\u3002", (String)"SrcQuestionPriceClarifyHandler_0", (String)"scm-src-common", (Object[])new Object[0]));
            return;
        }
        this.createSupplierClarify(context, purlistMap);
    }

    public void createSupplierClarify(PdsQuestionContext context, Map<Long, List<DynamicObject>> purlistMap) {
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(purlistMap.size());
        List billProperties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)context.getView().getModel().getDataEntity());
        List entryProperties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)purlistMap.get(purlistMap.keySet().iterator().next()).get(0));
        Set<String> excludedFields = this.getExcludedFields();
        AttachmentPanel attachmentPanel = (AttachmentPanel)context.getView().getControl("attachmentpanel");
        List attachments = attachmentPanel.getAttachmentData();
        DynamicObject questionObj = context.getView().getModel().getDataEntity(true);
        DynamicObjectCollection rows = questionObj.getDynamicObjectCollection("entryentity");
        rows.removeAll((Collection)rows);
        MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)questionObj, purlistMap.keySet(), (String)"supplierscope");
        for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
            DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)"tnd_question");
            PdsCommonUtils.setPrimaryKey((DynamicObject)billObj);
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)context.getView().getModel().getDataEntity(true), (DynamicObject)billObj, (List)billProperties, excludedFields, (int)-1);
            this.copyAttachment(attachments, billObj.getLong("id"));
            this.setBillValue(context, billObj, entry.getKey());
            this.setEntryValue(billObj, entry.getValue(), entryProperties, excludedFields);
            billObjs.add(billObj);
            rows.addAll((Collection)entry.getValue());
        }
        try (TXHandle h = TX.required();){
            try {
                PdsCommonUtils.saveDynamicObjects(billObjs);
                PdsCommonUtils.saveDynamicObjects((DynamicObject)questionObj);
            }
            catch (Exception e) {
                context.setSucced(false);
                context.setMessage(ResManager.loadKDString((String)"\u6309\u4f9b\u5e94\u5546\u751f\u6210\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u3002", (String)"SrcQuestionPriceClarifyHandler_1", (String)"scm-src-common", (Object[])new Object[0]));
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    public void copyAttachment(List<Map<String, Object>> attachments, long billId) {
        if (null == attachments || attachments.size() == 0) {
            return;
        }
        AttachmentUtils.convertTempAttachments(attachments);
        AttachmentServiceHelper.upload((String)"src_question", (Object)billId, (String)"attachmentpanel", attachments);
    }

    public void setEntryValue(DynamicObject billObj, List<DynamicObject> purlistObjs, List<String> properties, Set<String> excludedFields) {
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        int index = 1;
        for (DynamicObject purlistObj : purlistObjs) {
            DynamicObject row = rows.addNew();
            PdsCommonUtils.copyDynamicObjectValue((DynamicObject)purlistObj, (DynamicObject)row, properties, excludedFields, (int)index++);
        }
    }

    public void setBillValue(PdsQuestionContext context, DynamicObject billObj, long supplierId) {
        PdsCommonUtils.setBillNo((String)"src_question", (DynamicObject)billObj);
        billObj.set("suppliertype", (Object)"bd_supplier");
        billObj.set("supplier", (Object)supplierId);
        SupplierUtil.setSupplierUser((DynamicObject)billObj, (long)context.getView().getModel().getDataEntity().getLong("project.id"), (long)supplierId);
        MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)billObj, (long)supplierId, (String)"supplierscope");
        billObj.set("origin", (Object)"2");
        billObj.set("publishtype", (Object)"6");
    }

    public Map<Long, List<DynamicObject>> getPurlistMap(PdsQuestionContext context) {
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        int[] selectIndexs = entryGrid.getSelectRows();
        if (selectIndexs.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(selectIndexs.length);
        for (int index = 0; index < selectIndexs.length; ++index) {
            rows.add(context.getView().getModel().getEntryRowEntity("entryentity", selectIndexs[index]));
        }
        return rows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplierpk.id")));
    }

    public Set<String> getExcludedFields() {
        HashSet<String> excludedFields = new HashSet<String>(4);
        excludedFields.add("supplier");
        excludedFields.add("isnew");
        excludedFields.add("origin");
        excludedFields.add("bizpartner");
        return excludedFields;
    }
}

