/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question.clarify;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.question.IPdsQuestionHandler;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class SrcQuestionPriceClarifyProChg
implements IPdsQuestionHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsQuestionContext context) {
        this.propertyChanged(context);
    }

    protected void propertyChanged(PdsQuestionContext context) {
        String key;
        switch (key = context.getProChgArgs().getProperty().getName()) {
            case "project": 
            case "package": 
            case "isprice": {
                this.createPurlistEntryData(context);
                break;
            }
        }
    }

    public void createPurlistEntryData(PdsQuestionContext context) {
        if (!context.getView().getModel().getDataEntity().getBoolean("isclarify")) {
            return;
        }
        long projectId = context.getView().getModel().getDataEntity().getLong("project.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        long packageId = context.getView().getModel().getDataEntity().getLong("package.id");
        if (packageId > 0L) {
            qfilter.and("package", "=", (Object)packageId);
        }
        Set entryStatus = PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.OPENED.getValue()});
        qfilter.and("entrystatus", "in", (Object)entryStatus);
        String orderBy = PdsOrderByUtils.getOrderByString((String)"orderby001");
        Set excFields = PdsCommonUtils.buildSet((String[])new String[]{"isnew"});
        TemplateUtil.loadCompEntryData((IFormView)context.getView(), (String)"src_purlistf7", (QFilter)qfilter, (Set)excFields, (String)"entryentity", (String)orderBy, (boolean)false);
        this.initEntryNewValue(context);
    }

    public void initEntryNewValue(PdsQuestionContext context) {
        int count = context.getView().getModel().getEntryRowCount("entryentity");
        DynamicObject newObj = context.getView().getModel().getEntryRowEntity("entryentity", 0);
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
        context.getView().getModel().beginInit();
        for (int index = 0; index < count; ++index) {
            this.setEntryNewValue(context, properties, index);
        }
        context.getView().getModel().endInit();
        context.getView().updateView("entryentity");
    }

    public void setEntryNewValue(PdsQuestionContext context, List<String> properties, int index) {
        boolean isCopyPrice = context.getView().getModel().getDataEntity().getBoolean("isprice");
        Set<String> priceFields = this.getPriceFields();
        for (String fieldName : properties) {
            if (!fieldName.contains("_new") || !isCopyPrice && priceFields.contains(fieldName)) continue;
            context.getView().getModel().setValue(fieldName, context.getView().getModel().getValue(fieldName.substring(0, fieldName.lastIndexOf(95) <= 0 ? fieldName.length() : fieldName.lastIndexOf(95)), index), index);
        }
    }

    public Set<String> getPriceFields() {
        HashSet<String> fieldSet = new HashSet<String>(4);
        fieldSet.add("price_new");
        fieldSet.add("taxprice_new");
        fieldSet.add("amount_new");
        fieldSet.add("taxamount_new");
        return fieldSet;
    }
}

