/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.question.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.attach.AttachmentUtils;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcQuestionQuerySplitSuppliers
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()), (String)"src_question");
        context.setBillObj(billObj);
        this.splitSuppliers(context);
    }

    public void splitSuppliers(ExtPluginContext context) {
        if (!"1".equals(context.getBillObj().getString("origin")) || !"4".equals(context.getBillObj().getString("publishtype"))) {
            return;
        }
        if (!context.getBillObj().getString("billstatus").equals(BillStatusEnum.AUDIT.getVal())) {
            return;
        }
        DynamicObjectCollection supplierRows = context.getBillObj().getDynamicObjectCollection("supplierscope");
        if (supplierRows.size() <= 1) {
            return;
        }
        this.splitHandle(context);
    }

    public void splitHandle(ExtPluginContext context) {
        DynamicObject billObj = context.getBillObj();
        List supplierIds = MultiBasedataUtils.getBasedataIdSet((DynamicObject)billObj, (String)"supplierscope").stream().collect(Collectors.toList());
        ArrayList<DynamicObject> billObjList = new ArrayList<DynamicObject>(supplierIds.size());
        MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)billObj, (long)((Long)supplierIds.get(0)), (String)"supplierscope");
        billObjList.add(billObj);
        HashSet<String> ids = new HashSet<String>(1);
        ids.add(String.valueOf(billObj.getPkValue()));
        for (int i = 1; i < supplierIds.size(); ++i) {
            DynamicObject newBillObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)billObj, (boolean)true, (boolean)true);
            PdsCommonUtils.setPrimaryKey((DynamicObject)newBillObj);
            PdsCommonUtils.setBillNo((String)"src_question", (DynamicObject)newBillObj);
            MultiBasedataUtils.setMultiBasedataForBillObj((DynamicObject)newBillObj, (long)((Long)supplierIds.get(i)), (String)"supplierscope");
            AttachmentUtils.cloneAttachments((String)"src_question", ids, (String)"src_question", (DynamicObject)newBillObj, null);
            billObjList.add(newBillObj);
        }
        try (TXHandle h = TX.required();){
            try {
                PdsCommonUtils.saveDynamicObjects(billObjList);
            }
            catch (Exception e) {
                PdsCommonUtils.doOperation((DynamicObject)billObj, (String)"unaudit");
                context.setSucced(false);
                context.setMessage(ResManager.loadKDString((String)"\u6309\u4f9b\u5e94\u5546\u751f\u6210\u5355\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u53d1\u5e03\u3002", (String)"SrcQuestionQuerySplitSuppliers_0", (String)"scm-src-common", (Object[])new Object[0]));
                h.markRollback();
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }
}

