/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.analyse;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.ISrcScore;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.scorerfilter.SrcScorerFilterFacade;

public interface ISrcScoreReturnVerify
extends ISrcScore {
    default public String getSelectFields() {
        String selectFields = "id,billno,opentype,template,entrymainflow.biznode,entrymainflow.bizobject,entrymainflow.flowbizstatus,entrysubflow.subbiznode,entrysubflow.subbizobject,entrysubflow.subflowbizstatus";
        return selectFields;
    }

    default public Set<String> getStatusSet() {
        return PdsCommonUtils.buildSet((String[])new String[]{BillStatusEnum.SUBMIT.getVal(), BillStatusEnum.AUDIT.getVal(), BillStatusEnum.CLOSED.getVal()});
    }

    default public String getAptitudeName(SrcScoreContext context) {
        Map<String, Object> paramMap = context.getParamMap();
        if (null == paramMap) {
            return null;
        }
        String baseType = PdsCommonUtils.object2String((Object)paramMap.get("basetype"), (String)"");
        if ("4".equals(baseType) || "src_aptitudeaudit".equals(context.getView().getParentView().getEntityId())) {
            return "src_aptitudeaudit";
        }
        if ("7".equals(baseType) || "src_aptitudeaudit2".equals(context.getView().getParentView().getEntityId())) {
            return "src_aptitudeaudit2";
        }
        if ("8".equals(baseType) || "src_expertevaluate".equals(context.getView().getParentView().getEntityId())) {
            return "src_expertevaluate";
        }
        return null;
    }

    default public Set<Long> getProjectIdSet(SrcScoreContext context) {
        return Arrays.asList((Object[])context.getScorerMap().get("scorer")).stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
    }

    default public Set<Long> getManageProjectIds(SrcScoreContext context) {
        return SrcScorerFilterFacade.getManageProjectIds(this.getProjectIdSet(context), context.getParamMap());
    }

    default public Set<String> getBaseTypes(SrcScoreContext context) {
        return Arrays.asList((Object[])context.getScorerMap().get("scorer")).stream().map(e -> e.getString("billid.basetype")).collect(Collectors.toSet());
    }

    default public Set<String> getScorerSet(SrcScoreContext context) {
        return Arrays.asList((Object[])context.getScorerMap().get("scorer")).stream().map(e -> e.getString("scorer.id") + '_' + e.getString("scorer.name")).collect(Collectors.toSet());
    }
}

