/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.analyse;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.analyse.ISrcScoreReturnHandle;

public class SrcReturnBidopenPackage
implements ISrcScoreReturnHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        if (!context.isEvaluate()) {
            this.updateBidopenPackage(context.getScorerMap());
        }
    }

    private void updateBidopenPackage(Map<String, DynamicObject[]> scorerMap) {
        DynamicObject[] scorerObjs = scorerMap.get("scorer");
        Set basetypeSet = Arrays.asList(scorerObjs).stream().map(e -> e.getString("billid.basetype")).distinct().collect(Collectors.toSet());
        Set projectIdSet = Arrays.asList(scorerObjs).stream().map(e -> e.getLong("project.id")).distinct().collect(Collectors.toSet());
        Set packageIdSet = Arrays.asList(scorerObjs).stream().map(e -> e.getLong("package.id")).distinct().collect(Collectors.toSet());
        QFilter qfilters = new QFilter("billid", "in", projectIdSet);
        qfilters.and("package.id", "in", packageIdSet);
        DynamicObject[] packageObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)"project,istecassess,tecassessdate,isbizassess,bizassessdate", (QFilter[])qfilters.toArray());
        if (packageObjs == null || packageObjs.length == 0) {
            return;
        }
        for (DynamicObject packageObj : packageObjs) {
            if (basetypeSet.contains("1") || basetypeSet.contains("3")) {
                packageObj.set("istecassess", (Object)Boolean.FALSE);
                packageObj.set("tecassessdate", null);
            }
            if (!basetypeSet.contains("2")) continue;
            packageObj.set("isbizassess", (Object)Boolean.FALSE);
            packageObj.set("bizassessdate", null);
        }
        SaveServiceHelper.save((DynamicObject[])packageObjs);
    }
}

