/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.analyse;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.enums.SrcProjectEnum;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.analyse.ISrcScoreReturnHandle;

public class SrcReturnSrcScoreTask
implements ISrcScoreReturnHandle {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        if (!context.isEvaluate()) {
            this.updateSrcScoreTask(context.getScorerMap());
        }
    }

    private void updateSrcScoreTask(Map<String, DynamicObject[]> scorerMap) {
        DynamicObject[] projectObjs;
        DynamicObject[] scorerObjs = scorerMap.get("scorer");
        Set projectIdSet = Arrays.stream(scorerObjs).map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        for (DynamicObject projectObj : projectObjs = BusinessDataServiceHelper.load((Object[])projectIdSet.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"src_scorertask").getDynamicObjectType())) {
            if (!Objects.equals(projectObj.getString("billstatus"), SrcProjectEnum.AUDIT.getCode())) continue;
            PdsCommonUtils.doOperation((DynamicObject)projectObj, (String)"unaudit");
        }
    }
}

