/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.assessstatus;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.bidopen.SrcBidOpenUtils;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.assessstatus.ISrcAssessStatusHandler;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusContext;
import kd.scm.src.common.util.SrcPurListUtil;

public class SrcScoreAssessStatusHandler
implements ISrcAssessStatusHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcAssessStatusContext context) {
        this.handleAssessStatus(context);
    }

    protected void handleAssessStatus(SrcAssessStatusContext context) {
        DynamicObject[] packageObjs;
        boolean isAptitudeScore1 = SrcScoreHelper.isAptitudeScore1(context.getScoreContext());
        boolean isAptitudeScore2 = SrcScoreHelper.isAptitudeScore2(context.getScoreContext());
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)context.getScorertaskObj());
        context.setProjectId(projectId);
        boolean isOpenTecBefore = SrcBidOpenUtils.isOpenTecBeforePublish(context.getScorertaskObj());
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_bidopenpackage", (boolean)false);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        if (!isAptitudeScore1 && !isOpenTecBefore) {
            qfilter.and("id", "in", SrcPurListUtil.getValidPackageIds(projectId));
        }
        if ((packageObjs = BusinessDataServiceHelper.load((String)"src_bidopenpackage", (String)selectFields, (QFilter[])qfilter.toArray())) == null || packageObjs.length == 0) {
            return;
        }
        context.setPackageObjs(packageObjs);
        context.setPackageNum(packageObjs.length);
        for (DynamicObject packageObj : packageObjs) {
            long packageId = packageObjs.length > 1 ? SrmCommonUtil.getPkValue((DynamicObject)packageObj) : 0L;
            context.setPackageId(packageId);
            context.setPackageObj(packageObj);
            context.setPackageChanged(false);
            if (isAptitudeScore1) {
                SrcScoreHelper.handleAptStatus(context);
            } else if (isAptitudeScore2) {
                SrcScoreHelper.handleAptStatus2(context);
            } else if ("2".equals(context.getScorertaskObj().getString("opentype"))) {
                SrcScoreHelper.handleBizStatus(context);
                SrcScoreHelper.handleTecStatus(context);
            } else {
                SrcScoreHelper.handleTecStatus(context);
                SrcScoreHelper.handleBizStatus(context);
            }
            if (!context.isPackageChanged()) continue;
            context.getPackageList().add(packageObj);
        }
        SrcScoreHelper.handleScorerTaskStatus(context);
    }
}

