/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.assessstatus;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.src.common.enums.SrcBizStatusEnum;
import kd.scm.src.common.score.assessstatus.ISrcAssessStatusHandler;
import kd.scm.src.common.score.assessstatus.SrcAssessStatusContext;
import kd.scm.src.common.util.SrcBidCompTplUtil;

public class SrcScorerTaskStatusHandler
implements ISrcAssessStatusHandler {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcAssessStatusContext context) {
        if (context.getPackageNum() > 0) {
            context.setFinishScore(false);
        }
        if (context.getPackageNum() == 0) {
            this.setScorerTaskStatus(context);
        }
    }

    protected void setScorerTaskStatus(SrcAssessStatusContext context) {
        boolean isTaskChanged = false;
        DynamicObject scorerTaskObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_scorertask");
        if (!scorerTaskObj.getString("scorestatus").equals(ProcessStatusEnums.PROCESSED.getValue())) {
            scorerTaskObj.set("scorestatus", (Object)ProcessStatusEnums.PROCESSED.getValue());
            context.setFinishScore(true);
            isTaskChanged = true;
        }
        if (context.isAuditScore()) {
            this.audoAudit(scorerTaskObj);
            isTaskChanged = true;
        }
        if (isTaskChanged) {
            context.getScorertaskList().add(scorerTaskObj);
        }
    }

    private void audoAudit(DynamicObject scorerTaskObj) {
        scorerTaskObj.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
        scorerTaskObj.set("bizstatus", (Object)ProcessStatusEnums.PROCESSED.getValue());
        scorerTaskObj.set("auditor", (Object)RequestContext.get().getCurrUserId());
        scorerTaskObj.set("auditdate", (Object)TimeServiceHelper.now());
        SrcBidCompTplUtil.updateCurrFlowEntryNode(scorerTaskObj, "audit");
        if (SrcBidCompTplUtil.isNeedAudit(scorerTaskObj)) {
            SrcBidCompTplUtil.updateNextNode(scorerTaskObj, SrcBizStatusEnum.PROCESSING.getVal());
            SrcBidCompTplUtil.updateCurrentNode(scorerTaskObj);
        }
    }
}

