/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.prepare;

import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.prepare.ISrcScoreGetQFilter;

public class SrcScoreGetQFilterDynamic
implements ISrcScoreGetQFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public QFilter buildQFilter(SrcScoreContext context, QFilter qfilter) {
        String scoreStatus;
        String billno;
        long purOrgId;
        long supplierId;
        long packageId;
        Set<Long> taskIdSet;
        long projectId;
        Date dateTo;
        Date dateFrom = context.getDateFrom();
        if (null != dateFrom) {
            qfilter.and("billdate", ">=", (Object)dateFrom);
        }
        if (null != (dateTo = context.getDateTo())) {
            qfilter.and("billdate", "<=", (Object)dateTo);
        }
        if ((projectId = context.getProjectId()) > 0L) {
            qfilter.and("project", "=", (Object)projectId);
        }
        if (null != (taskIdSet = context.getProjectSet()) && taskIdSet.size() > 0) {
            qfilter.and("id", "in", taskIdSet);
        }
        if ((packageId = context.getPackageId()) > 0L) {
            qfilter.and("package", "=", (Object)packageId);
        }
        if ((supplierId = context.getSupplierId()) > 0L) {
            qfilter.and("supplier", "=", (Object)supplierId);
        }
        if ((purOrgId = context.getPurOrgId()) > 0L) {
            qfilter.and("org", "=", (Object)purOrgId);
        }
        if (!StringUtils.isBlank((CharSequence)(billno = context.getBillNo()))) {
            qfilter.and("billno", "like", (Object)("%" + billno + "%"));
        }
        if (null != (scoreStatus = context.getScoreStatus()) && scoreStatus.equals("0")) {
            qfilter.and("entry.subentry.scorerscored", "=", (Object)"0");
        }
        if (null != scoreStatus && scoreStatus.equals("1")) {
            qfilter.and("entry.subentry.scorerscored", "=", (Object)"1");
        }
        return qfilter;
    }
}

