/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.process.ISrcScoreCalcPrepare;

public class SrcScoreCalcPrepare
implements ISrcScoreCalcPrepare {
    @Override
    public void process(SrcScoreContext context) {
        this.prepareDefaultValue(context);
        this.prepareCalcData(context);
    }

    protected void prepareDefaultValue(SrcScoreContext context) {
        context.setCalcSucced(false);
        context.setScorerScored(false);
        context.setScorerVeto("9");
        context.setScore(BigDecimal.valueOf(-1L));
        context.setScorerScore(BigDecimal.ZERO);
    }

    protected void prepareCalcData(SrcScoreContext context) {
        BigDecimal classRatio;
        DynamicObject scoreRow = context.getCurrentScoreRow();
        if (scoreRow == null) {
            return;
        }
        String property = scoreRow.getString("index.property");
        context.setProperty(property);
        boolean isFormula = scoreRow.getBoolean("index.isformula");
        context.setFormula(isFormula);
        String scoreMethod = PdsCommonUtils.object2String((Object)scoreRow.get("index.scoremethod"), (String)"1");
        context.setScoreMethod(scoreMethod);
        BigDecimal schemeScore = BigDecimal.valueOf(100L);
        if ("3".equals(scoreMethod) && (schemeScore = scoreRow.getBigDecimal("index.schemescore")).compareTo(BigDecimal.ZERO) <= 0) {
            schemeScore = BigDecimal.valueOf(100L);
        }
        if ((classRatio = scoreRow.getBigDecimal("indexweight").divide(schemeScore, 10, 5)).compareTo(BigDecimal.ZERO) == 0) {
            classRatio = BigDecimal.ONE;
        }
        context.setClassRatio(classRatio);
        BigDecimal indexScore = scoreRow.getBigDecimal("index.score");
        context.setIndexScore(indexScore);
        BigDecimal indexRatio = BigDecimal.ONE;
        switch (scoreMethod) {
            case "1": {
                indexRatio = indexScore.divide(BigDecimal.valueOf(100L));
                break;
            }
            case "2": {
                indexRatio = BigDecimal.ONE;
                break;
            }
            case "3": {
                indexRatio = BigDecimal.ONE;
            }
        }
        context.setIndexRatio(indexRatio);
        BigDecimal scorerRatio = indexRatio.multiply(classRatio);
        if (scorerRatio.compareTo(BigDecimal.ZERO) == 0) {
            // empty if block
        }
        context.setScorerRatio(scorerRatio);
        BigDecimal scorerWeight = scoreRow.getBigDecimal("scorerweight").divide(BigDecimal.TEN.multiply(BigDecimal.TEN));
        if (scorerWeight.compareTo(BigDecimal.ZERO) <= 0) {
            scorerWeight = BigDecimal.ONE;
        }
        context.setScorerWeight(scorerWeight);
        String txtValue = scoreRow.getString("value");
        context.setTxtValue(txtValue);
        BigDecimal value = txtValue == null ? BigDecimal.ZERO : (txtValue.length() <= 0 ? BigDecimal.ZERO : new BigDecimal(txtValue));
        context.setValue(value);
        context.setNote(scoreRow.getString("note"));
        BigDecimal lowValue = (BigDecimal)scoreRow.get("index.lowvalue");
        context.setLowValue(lowValue);
        BigDecimal hightValue = (BigDecimal)scoreRow.get("index.hightvalue");
        context.setHightValue(hightValue);
        StringBuilder sbValue = new StringBuilder().append(value);
        BigDecimal calcValue = value;
        if ("1".equals(context.getScoreMethod())) {
            calcValue = value.multiply(indexScore.divide(BigDecimal.TEN).divide(BigDecimal.TEN));
            sbValue.append('\u00d7');
            sbValue.append(String.valueOf(indexScore.setScale(0, RoundingMode.HALF_UP)));
            sbValue.append("/100=");
            sbValue.append(String.valueOf(calcValue.setScale(2, RoundingMode.HALF_UP)));
        }
        context.setSbValue(sbValue);
        context.setCalcValue(calcValue);
    }
}

