/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.process;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.process.ISrcScoreCalcScore;

public class SrcScoreCalcScore
implements ISrcScoreCalcScore {
    @Override
    public void process(SrcScoreContext context) {
        this.calculateScore(context);
    }

    protected void calculateScore(SrcScoreContext context) {
        BigDecimal value = BigDecimal.valueOf(-1L);
        if (context.getProperty().equals("1")) {
            if (context.isFormula()) {
                value = this.getScoreByFormula(context.getValue());
            } else if (context.getValue().compareTo(BigDecimal.ZERO) >= 0) {
                value = context.getValue();
            }
        } else if (context.getValue().multiply(context.getIndexRatio()).compareTo(context.getIndexScore()) <= 0) {
            value = context.getValue();
        } else {
            context.setVerifySucced(false);
            context.setVerifyMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c \u5f97\u5206\u4e0d\u80fd\u5927\u4e8e\u6307\u6807\u5206\u503c\u3002", (String)"SrcScoreCalcScore_0", (String)"scm-src-common", (Object[])new Object[0]), context.getCurrentRowIndex() + 1));
        }
        context.setScore(value.multiply(context.getIndexRatio()));
        BigDecimal scorerScore = value.multiply(context.getScorerRatio()).multiply(context.getScorerWeight());
        context.setScorerScore(scorerScore);
        if (value.compareTo(BigDecimal.ZERO) >= 0) {
            context.setCalcSucced(true);
            context.setScorerScored(true);
        } else {
            context.setVerifySucced(false);
            context.setVerifyMessage(ResManager.loadKDString((String)"\u8bc4\u4f30\u503c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrcScoreCalcScore_1", (String)"scm-src-common", (Object[])new Object[0]));
        }
    }

    protected BigDecimal getScoreByFormula(BigDecimal value) {
        return value;
    }
}

