/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;

public class SrcScoreTaskCreateSchemeIndex
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        this.createBizSchemeIndexs(context);
    }

    protected void createBizSchemeIndexs(SrcScoreTaskContext context) {
        String sumType;
        DynamicObject sumTypeObj = QueryServiceHelper.queryOne((String)"src_compare_config", (String)"scheme.sumtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getProjectId())});
        switch (sumType = PdsCommonUtils.object2String((Object)sumTypeObj.getString("scheme.sumtype"), (String)"3")) {
            case "1": {
                this.createBizSchemeIndexs(context, "project", "bidname");
                break;
            }
            case "2": {
                this.createBizSchemeIndexs(context, "package", "packagename");
                break;
            }
            case "3": {
                if (context.isCreateBizIndex()) {
                    this.createBizSchemeIndexsByQuote(context, "purlist", "materialnane");
                    break;
                }
                this.createBizSchemeIndexs(context, "purlist", "materialnane");
                break;
            }
        }
    }

    protected void createBizSchemeIndexs(SrcScoreTaskContext context, String field, String name) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            qFilter.and("package.id", "=", (Object)context.getPackageId());
        }
        qFilter.and("billtype", "=", (Object)"1");
        qFilter.and("isbizitem", "=", (Object)"0");
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)field, (QFilter[])qFilter.toArray());
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> purlistMap = Arrays.asList(purlistObjs).stream().collect(Collectors.groupingBy(e -> e.getLong(field + '.' + "id")));
        ArrayList<DynamicObject> indexObjs = new ArrayList<DynamicObject>(purlistMap.size());
        DynamicObjectCollection schemeIndexs = context.getSchemeObj().getDynamicObjectCollection("entryentity");
        for (DynamicObject schemeIndex : schemeIndexs) {
            for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
                DynamicObject indexObj = BusinessDataServiceHelper.newDynamicObject((String)"src_indexf7");
                this.setIndexDefaultValue(context, schemeIndex, indexObj);
                indexObj.set("srcentryid", (Object)entry.getKey());
                indexObj.set("indexdimension", (Object)entry.getValue().get(0).getString(field + "." + name));
                indexObjs.add(indexObj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(indexObjs);
    }

    protected void createBizSchemeIndexsByQuote(SrcScoreTaskContext context, String field, String name) {
        QFilter qFilter = new QFilter("project.id", "=", (Object)context.getProjectId());
        if (context.getPackageId() > 0L) {
            qFilter.and("package.id", "=", (Object)context.getPackageId());
        }
        qFilter.and("supplier", ">", (Object)0);
        qFilter.and("entrystatus", "in", (Object)PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.TOQUOTE.getValue(), ProjectStatusEnums.QUOTED.getValue(), ProjectStatusEnums.OPENED.getValue()}));
        qFilter.and("isbizitem", "=", (Object)"0");
        qFilter.and("isdiscarded", "=", (Object)"0");
        qFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.TERMINATED.getValue());
        qFilter.and("entrystatus2", "!=", (Object)ProjectStatusEnums.INVALID.getValue());
        DynamicObject[] purlistObjs = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)"id,materialnane,supplier.id", (QFilter[])qFilter.toArray());
        if (purlistObjs == null || purlistObjs.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> purlistMap = Arrays.asList(purlistObjs).stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        ArrayList<DynamicObject> indexObjs = new ArrayList<DynamicObject>(purlistMap.size());
        DynamicObjectCollection schemeIndexs = context.getSchemeObj().getDynamicObjectCollection("entryentity");
        for (DynamicObject schemeIndex : schemeIndexs) {
            for (Map.Entry<Long, List<DynamicObject>> entry : purlistMap.entrySet()) {
                DynamicObject indexObj = BusinessDataServiceHelper.newDynamicObject((String)"src_indexf7");
                this.setIndexDefaultValue(context, schemeIndex, indexObj);
                indexObj.set("srcentryid", (Object)entry.getKey());
                indexObj.set("indexdimension", (Object)entry.getValue().get(0).getString("materialnane"));
                indexObj.set("supplier", (Object)entry.getValue().get(0).getLong("supplier.id"));
                indexObjs.add(indexObj);
            }
        }
        PdsCommonUtils.saveDynamicObjects(indexObjs);
    }

    protected void setIndexDefaultValue(SrcScoreTaskContext context, DynamicObject schemeIndex, DynamicObject indexObj) {
        indexObj.set("billid", (Object)context.getProjectId());
        indexObj.set("indexlib", (Object)context.getPackageId());
        indexObj.set("indextype", (Object)context.getSchemeObj().getLong("type.id"));
        indexObj.set("indexclass", (Object)context.getSchemeObj().getLong("type.id"));
        indexObj.set("scoremethod", (Object)context.getSchemeObj().getString("scoremethod"));
        indexObj.set("schemescore", (Object)context.getSchemeObj().getString("schemescore"));
        indexObj.set("index", (Object)schemeIndex.getString("index"));
        indexObj.set("indexrule", (Object)schemeIndex.getString("indexrule"));
        indexObj.set("property", (Object)schemeIndex.getString("property"));
        indexObj.set("scoretype", (Object)schemeIndex.getString("scoretype"));
        indexObj.set("score", (Object)schemeIndex.getBigDecimal("score"));
        indexObj.set("srcindexid", schemeIndex.getPkValue());
        indexObj.set("srcindexlibid", (Object)schemeIndex.getLong("indexlib.id"));
        indexObj.set("isfitted", (Object)schemeIndex.getString("isfitted"));
        indexObj.set("isopinion", (Object)schemeIndex.getString("isopinion"));
        indexObj.set("isthreshold", (Object)schemeIndex.getString("isthreshold"));
        indexObj.set("threshold", (Object)schemeIndex.getString("threshold"));
        indexObj.set("lowvalue", (Object)schemeIndex.getString("lowvalue"));
        indexObj.set("hightvalue", (Object)schemeIndex.getString("hightvalue"));
        indexObj.set("note", (Object)schemeIndex.getString("note"));
        indexObj.set("veto", (Object)schemeIndex.getString("veto"));
        indexObj.set("isformula", (Object)schemeIndex.getString("isformula"));
        indexObj.set("isdeduct", (Object)schemeIndex.getString("isdeduct"));
        indexObj.set("isscoretask", (Object)"1");
    }
}

