/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.RandomUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;

public class SrcScoreTaskCreateSupplierCode
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        if (!context.isExpertEvaluate()) {
            this.createSupplierCode(context);
        }
    }

    protected void createSupplierCode(SrcScoreTaskContext context) {
        QFilter qfilter = this.getProjectFilter(context, "id");
        DynamicObject bidOpenCfgObj = QueryServiceHelper.queryOne((String)"src_bidopen_config", (String)"ishidesupplier", (QFilter[])qfilter.toArray());
        if (!bidOpenCfgObj.getBoolean("ishidesupplier")) {
            return;
        }
        HashSet<String> supplierCodes = new HashSet<String>(16);
        HashMap<Long, String> supplierCodeMap = new HashMap<Long, String>(16);
        this.getSupplierCodeMap(context, supplierCodes, supplierCodeMap);
        this.updateSupplierCode(context, "src_supplierinvite", "billid", supplierCodes, supplierCodeMap);
        this.updateSupplierCode(context, "src_bidopensupplier", "billid", supplierCodes, supplierCodeMap);
        this.updateSupplierCode(context, "src_biddoctplf7", "project", supplierCodes, supplierCodeMap);
        this.updateSupplierCode(context, "src_purlistf7", "project", supplierCodes, supplierCodeMap);
        this.updateSupplierCode(context, "src_scoretask", "project", supplierCodes, supplierCodeMap);
    }

    protected void getSupplierCodeMap(SrcScoreTaskContext context, Set<String> supplierCodes, Map<Long, String> supplierCodeMap) {
        QFilter qfilter = this.getProjectFilter(context, "billid");
        qfilter.and("suppliercode", "!=", (Object)Character.valueOf(' '));
        qfilter.and("suppliercode", "is not null", (Object)"");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_supplierinvite", (String)"suppliertype,supplier.id,suppliercode", (QFilter[])qfilter.toArray());
        if (rows.size() == 0) {
            return;
        }
        supplierCodes.addAll(rows.stream().map(e -> e.getString("suppliercode")).collect(Collectors.toSet()));
        supplierCodeMap.putAll(rows.stream().collect(Collectors.groupingBy(e -> e.getLong("supplier.id"), Collectors.collectingAndThen(Collectors.toList(), value -> ((DynamicObject)value.get(0)).getString("suppliercode")))));
    }

    protected void updateSupplierCode(SrcScoreTaskContext context, String entityName, String keyField, Set<String> supplierCodes, Map<Long, String> supplierCodeMap) {
        QFilter qfilter = this.getProjectFilter(context, keyField);
        qfilter.and("suppliercode", "=", (Object)Character.valueOf(' '));
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)"suppliertype,supplier.id,suppliercode", (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        for (DynamicObject row : rows) {
            long supplierId = row.getLong("supplier.id");
            String supplierCode = supplierCodeMap.get(supplierId);
            if (null == supplierCode) {
                supplierCode = RandomUtils.generateRandomCode((int)4, supplierCodes);
                supplierCodeMap.put(supplierId, supplierCode);
            }
            row.set("suppliercode", (Object)supplierCode);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }

    private QFilter getProjectFilter(SrcScoreTaskContext context, String keyField) {
        return new QFilter(keyField, "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj()));
    }
}

