/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.push;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreTaskContext;
import kd.scm.src.common.score.push.ISrcScoreTaskPush;
import kd.scm.src.common.score.push.SrcScoreTaskFacade;

public class SrcScoreTaskCreateTaskBillObj
implements ISrcScoreTaskPush {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreTaskContext context) {
        this.createScoreTaskBillObj(context);
    }

    protected void createScoreTaskBillObj(SrcScoreTaskContext context) {
        DynamicObject tenderSupplier = context.getTenderSupplier();
        String supplierType = tenderSupplier.getString("suppliertype");
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)tenderSupplier.getDynamicObject("supplier"));
        String entityName = context.isExpertEvaluate() ? "src_evaluatetask" : "src_scoretask";
        DynamicObject scoreTaskObj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        String billNo = CodeRuleServiceHelper.getNumber((String)entityName, (DynamicObject)scoreTaskObj, null);
        scoreTaskObj.set("billno", (Object)billNo);
        scoreTaskObj.set("project", (Object)context.getProjectId());
        if (!"2".equals(context.getManageType())) {
            context.setPackageId(tenderSupplier.getLong("package.id"));
        }
        scoreTaskObj.set("package", (Object)context.getPackageId());
        scoreTaskObj.set("purlist", (Object)context.getPurlistId());
        scoreTaskObj.set("indextype", (Object)context.getIndextypeId());
        this.setBaseType(context, scoreTaskObj);
        scoreTaskObj.set("suppliertype", (Object)supplierType);
        scoreTaskObj.set("supplier", (Object)supplierId);
        scoreTaskObj.set("billdate", (Object)TimeServiceHelper.now());
        if ("publish".equals(context.getOperateKey())) {
            scoreTaskObj.set("cfmstatus", (Object)BillStatusEnum.SAVE.getVal());
            scoreTaskObj.set("cfmstatus_pur", (Object)BillStatusEnum.SAVE.getVal());
            scoreTaskObj.set("cfmstatus_sup", (Object)BillStatusEnum.SAVE.getVal());
            scoreTaskObj.set("isaptitudereply", (Object)"0");
            scoreTaskObj.set("bizstatus", (Object)"A");
        } else {
            scoreTaskObj.set("bizstatus", (Object)"B");
        }
        scoreTaskObj.set("billstatus", (Object)"C");
        if ("src_expertevaluate".equals(context.getBillObj().getDataEntityType().getName())) {
            scoreTaskObj.set("creator", (Object)context.getBillObj().getLong("creator.id"));
        } else {
            scoreTaskObj.set("creator", (Object)context.getBillObj().getLong("projectcreator.id"));
            scoreTaskObj.set("scorers", (Object)PdsCommonUtils.cloneCols((DynamicObject)context.getConfigObj(), (String)"scorer"));
            scoreTaskObj.set("agents", (Object)context.getConfigObj().getLong("agent.id"));
        }
        scoreTaskObj.set("createtime", (Object)TimeServiceHelper.now());
        scoreTaskObj.set("org", (Object)context.getBillObj().getLong("org.id"));
        scoreTaskObj.set("scoretype", (Object)context.getScoreType());
        scoreTaskObj.set("scheme", (Object)context.getSchemeObj());
        if (context.isAptitudeAudit() || context.isAptitudeAudit2()) {
            BigDecimal sumScore = context.getConfigObj().getBigDecimal("sumscore");
            if (sumScore.compareTo(BigDecimal.ZERO) > 0) {
                scoreTaskObj.set("minvalue", (Object)sumScore);
            } else {
                scoreTaskObj.set("minvalue", (Object)context.getSchemeObj().getBigDecimal("sumscore"));
            }
        } else {
            scoreTaskObj.set("minvalue", (Object)context.getSchemeObj().getBigDecimal("sumscore"));
        }
        scoreTaskObj.set("isaptitude", (Object)context.isAptitudeAudit());
        scoreTaskObj.set("isaptitude2", (Object)context.isAptitudeAudit2());
        scoreTaskObj.set("srcentryid", context.getConfigObj().getPkValue());
        BigDecimal indexscoreSum = BigDecimal.ZERO;
        String scoreMethod = context.getSchemeObj().getString("scoremethod");
        if (context.isByProject() && "2".equals(context.getScoreType())) {
            if (null != context.getSchemeIndexs()) {
                for (DynamicObject schemeIndex : context.getSchemeIndexs()) {
                    if (schemeIndex.getLong("indextype.id") != context.getIndextypeId()) continue;
                    BigDecimal indexscore = schemeIndex.getBigDecimal("score") == null ? BigDecimal.ZERO : schemeIndex.getBigDecimal("score");
                    BigDecimal maxIndexscore = indexscore.multiply(context.getWeight().divide(new BigDecimal("100"))).setScale(6);
                    indexscoreSum = indexscoreSum.add(maxIndexscore);
                }
            }
        } else if ("3".equals(scoreMethod)) {
            indexscoreSum = context.getWeight();
        } else if (context.isBizScore()) {
            indexscoreSum = context.getWeight();
        } else if (null != context.getSchemeIndexs()) {
            for (DynamicObject schemeIndex : context.getSchemeIndexs()) {
                BigDecimal indexscore = schemeIndex.getBigDecimal("score") == null ? BigDecimal.ZERO : schemeIndex.getBigDecimal("score");
                BigDecimal maxIndexscore = indexscore.multiply(context.getWeight().divide(new BigDecimal("100"))).setScale(6);
                indexscoreSum = indexscoreSum.add(maxIndexscore);
            }
        }
        scoreTaskObj.set("billindexscore", (Object)indexscoreSum);
        if (context.isExpertEvaluate()) {
            scoreTaskObj.set("gradescheme", (Object)context.getConfigObj().getLong("gradescheme.id"));
        }
        if ("publish".equals(context.getOperateKey()) && !"src_enrollsupplier".equals(tenderSupplier.getDataEntityType().getName())) {
            scoreTaskObj.set("ispuraptitude", tenderSupplier.get("ispuraptitude"));
        }
        this.resetMinValue(context, scoreTaskObj);
        ORM.create().setPrimaryKey(scoreTaskObj);
        context.setScoretaskId(PdsCommonUtils.object2Long((Object)scoreTaskObj.getPkValue()));
        context.setScoreTaskObj(scoreTaskObj);
    }

    private void resetMinValue(SrcScoreTaskContext context, DynamicObject scoreTaskObj) {
        if (context.isByProject() && null != context.getSchemeIndexs()) {
            BigDecimal indexscoreSum = BigDecimal.ZERO;
            for (DynamicObject schemeIndex : context.getSchemeIndexs()) {
                if (schemeIndex.getLong("indextype.id") != context.getIndextypeId()) continue;
                BigDecimal indexscore = schemeIndex.getBigDecimal("score") == null ? BigDecimal.ZERO : schemeIndex.getBigDecimal("score");
                BigDecimal maxIndexscore = indexscore.multiply(context.getWeight().divide(new BigDecimal("100"))).setScale(6);
                indexscoreSum = indexscoreSum.add(maxIndexscore);
            }
            BigDecimal minValue = context.getSchemeObj().getBigDecimal("sumscore").multiply(indexscoreSum.divide(new BigDecimal("100"))).setScale(6);
            scoreTaskObj.set("minvalue", (Object)minValue);
        }
    }

    public void setBaseType(SrcScoreTaskContext context, DynamicObject scoreTaskObj) {
        DynamicObject indexClassObj;
        if (null == context.getBaseTypeMap() || context.getBaseTypeMap().size() == 0 || null == context.getBaseTypeMap().get(context.getIndextypeId())) {
            SrcScoreTaskFacade.getBaseTypeMap(context);
        }
        if (null != (indexClassObj = context.getBaseTypeMap().get(context.getIndextypeId()))) {
            scoreTaskObj.set("basetype", (Object)indexClassObj.getString("basetype"));
        } else {
            scoreTaskObj.set("basetype", null);
        }
    }
}

