/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.util.SrcEvaluateUtils;

public class SrcScoreHandleAptitude
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        Set<Long> underThresholdSet = this.getUnderThresholdSet(context);
        DynamicObject[] scoreTaskObjs = this.getScoreTaskObjs(context);
        DynamicObject[] resultObjs = this.getAptitudeResultObjs(context);
        for (DynamicObject scoreTaskObj : scoreTaskObjs) {
            this.updateAptitudeResult(scoreTaskObj, underThresholdSet, resultObjs);
        }
        if (context.isEvaluate()) {
            SrcEvaluateUtils.updateEvaluateGrade(scoreTaskObjs, "grade", "gradescheme.id", "sumscore");
            SrcEvaluateUtils.updateEvaluateGrade(resultObjs, "grade", "scoretask.gradescheme.id", "scoretask.sumscore");
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])scoreTaskObjs);
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])resultObjs);
    }

    protected void updateAptitudeResult(DynamicObject scoreTaskObj, Set<Long> underThresholdSet, DynamicObject[] resultObjs) {
        BigDecimal minScore = scoreTaskObj.getBigDecimal("minvalue");
        if (minScore.compareTo(BigDecimal.ZERO) <= 0) {
            DynamicObject schemeObj = scoreTaskObj.getDynamicObject("scheme");
            minScore = schemeObj.getBigDecimal("sumscore");
            scoreTaskObj.set("minvalue", (Object)minScore);
        }
        String scoremethod = scoreTaskObj.getString("scheme.scoremethod");
        boolean isValid = false;
        if (!underThresholdSet.contains(scoreTaskObj.getPkValue())) {
            BigDecimal indexScore = scoreTaskObj.getBigDecimal("billindexscore");
            BigDecimal sumScore = scoreTaskObj.getBigDecimal("sumscore");
            if (!"3".equals(scoremethod)) {
                sumScore = sumScore.multiply(new BigDecimal(100));
                minScore = minScore.multiply(indexScore);
            }
            if (sumScore.compareTo(minScore) >= 0) {
                scoreTaskObj.set("isvalid", (Object)"1");
                isValid = true;
            }
        }
        this.updateAptidudeResult(resultObjs, SrmCommonUtil.getPkValue((DynamicObject)scoreTaskObj), isValid);
    }

    private void updateAptidudeResult(DynamicObject[] resultObjs, long billId, boolean isValid) {
        List rows = Arrays.stream(resultObjs).filter(e -> e.getLong("scoretask.id") == billId).collect(Collectors.toList());
        for (DynamicObject row : rows) {
            if (isValid) {
                row.set("isaptitude", (Object)"1");
                continue;
            }
            row.set("isaptitude", (Object)"2");
        }
    }

    private Set<Long> getUnderThresholdSet(SrcScoreContext context) {
        String entityName = context.isEvaluate() ? "src_evaluateanalyse" : "src_scoreanalyse";
        QFilter qFilter = new QFilter("billid", "in", context.getScoreTaskSet());
        qFilter.and("billid.bizstatus", "!=", (Object)"E");
        qFilter.and("isoverthreshold", "=", (Object)Boolean.TRUE);
        qFilter.and(SrcScoreHelper.getBaseTypeFilter(context, "billid.indextype.basetype"));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityName, (String)"billid.id", (QFilter[])qFilter.toArray());
        return rows.stream().map(e -> e.getLong("billid.id")).collect(Collectors.toSet());
    }

    private DynamicObject[] getScoreTaskObjs(SrcScoreContext context) {
        String entityName = context.isEvaluate() ? "src_evaluatetask" : "src_scoretask";
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        QFilter qfilter = new QFilter("id", "in", context.getScoreTaskSet());
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
    }

    private DynamicObject[] getAptitudeResultObjs(SrcScoreContext context) {
        String entityName = "src_bidassess_tec";
        if (context.isEvaluate()) {
            entityName = "src_evaluateresultf7";
        } else {
            Object baseType = context.getParamMap().get("basetype");
            if (null != baseType) {
                if (baseType instanceof List && ((List)baseType).contains("4")) {
                    entityName = "src_aptituderesultf7";
                } else if (baseType instanceof Set && ((Set)baseType).contains("4")) {
                    entityName = "src_aptituderesultf7";
                } else if (baseType.equals("4")) {
                    entityName = "src_aptituderesultf7";
                } else if (baseType instanceof List && ((List)baseType).contains("7")) {
                    entityName = "src_aptituderesult2f7";
                } else if (baseType instanceof Set && ((Set)baseType).contains("7")) {
                    entityName = "src_aptituderesult2f7";
                } else if (baseType.equals("7")) {
                    entityName = "src_aptituderesult2f7";
                }
            }
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        QFilter qfilter = new QFilter("scoretask", "in", context.getScoreTaskSet());
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray());
    }
}

