/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreFacade;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;
import kd.scm.src.common.score.result.SrcScoreHandleContext;

public class SrcScoreHandleScoreStatus
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.handleScoreTaskStatus(context);
    }

    protected void handleScoreTaskStatus(SrcScoreContext context) {
        SrcScoreHandleContext handleContext = context.getHandleContext();
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)handleContext.getScoreTaskObj().getDynamicObject("project.srctype"));
        boolean isCreateBizIndex = false;
        boolean isPushBizByPurlist = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPushBizScoreTaskByPurlist", (Object)false, (long)context.getProjectId()));
        if (!isPushBizByPurlist) {
            isCreateBizIndex = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isCreateBizIndexByQuoteBill", (Object)false, (long)context.getProjectId()));
        }
        if (handleContext.isAllScored()) {
            SrcScoreFacade.handleVeto(context);
            handleContext.getScoreTaskObj().set("bizstatus", (Object)SrmScoreStatusEnum.SCORED.getValue());
            BigDecimal sumScore = handleContext.getSumScore();
            if (isCreateBizIndex && "2".equals(handleContext.getScoreTaskObj().getString("basetype"))) {
                BigDecimal schemeScore = handleContext.getScoreTaskObj().getBigDecimal("scheme.schemescore");
                if (handleContext.getSumWeightScore().compareTo(schemeScore) > 0) {
                    sumScore = sumScore.multiply(schemeScore).divide(handleContext.getSumWeightScore(), 4, RoundingMode.HALF_DOWN);
                }
            }
            handleContext.getScoreTaskObj().set("sumscore", (Object)sumScore);
            handleContext.getScoreTaskObj().set("finishdate", (Object)TimeServiceHelper.now());
        } else if (handleContext.isPartScored()) {
            handleContext.getScoreTaskObj().set("bizstatus", (Object)SrmScoreStatusEnum.PARTSCORED.getValue());
        }
    }
}

