/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.result.ISrcScoreCommitScore;

public class SrcScoreUpdateDetail
implements ISrcScoreCommitScore {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        this.updateScoreDetail(context);
    }

    protected void updateScoreDetail(SrcScoreContext context) {
        ArrayList detailIds = new ArrayList(context.getScoreDetailMap().size());
        context.getScoreDetailMap().forEach((key, value) -> detailIds.add(Long.parseLong(key)));
        String entityName = context.isEvaluate() ? "src_evaluate_detail" : "src_score_detail";
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)false);
        DynamicObject[] detailObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)});
        if (detailObjs.length == 0) {
            return;
        }
        for (DynamicObject detailObj : detailObjs) {
            DynamicObject scoreObj = context.getScoreDetailMap().get(detailObj.getString("id"));
            if (scoreObj == null) continue;
            detailObj.set("isfitted", (Object)scoreObj.getBoolean("isfitted"));
            detailObj.set("value", (Object)scoreObj.getBigDecimal("value"));
            detailObj.set("score", (Object)scoreObj.getBigDecimal("score"));
            detailObj.set("scorerveto", (Object)scoreObj.getString("scorerveto"));
            detailObj.set("scorerscore", (Object)scoreObj.getBigDecimal("scorerscore"));
            detailObj.set("note", (Object)scoreObj.getString("note"));
            detailObj.set("reason", (Object)scoreObj.getString("reason"));
            detailObj.set("scorerscored", (Object)Boolean.TRUE);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])detailObjs);
        this.updateMytaksFinishTime(detailObjs);
    }

    protected void updateMytaksFinishTime(DynamicObject[] detailObjs) {
        Set srcEntryIds = Arrays.asList(detailObjs).stream().map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
        QFilter qfilters = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
        qfilters.and("srcentryid", "in", srcEntryIds);
        qfilters.and("finishdate", "is null", (Object)new Date());
        DynamicObject[] mytaskObjs = BusinessDataServiceHelper.load((String)"src_memberclarify", (String)"finishdate", (QFilter[])qfilters.toArray());
        Date finishTime = TimeServiceHelper.now();
        for (DynamicObject mytaskObj : mytaskObjs) {
            mytaskObj.set("finishdate", (Object)finishTime);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])mytaskObjs);
    }
}

