/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.scorerfilter;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.scorerfilter.ISrcScorerFilter;

public class SrcGetManageProjectIds
implements ISrcScorerFilter {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(SrcScoreContext context) {
        QFilter qfilters = new QFilter("bidder", "=", (Object)RequestContext.get().getCurrUserId());
        HashSet<String> bizRoles = new HashSet<String>(2);
        bizRoles.add("SYS001");
        String baseType = PdsCommonUtils.object2String((Object)context.getParamMap().get("basetype"), (String)"1");
        if (baseType.equals("4")) {
            bizRoles.add("SYS019");
        } else if (baseType.equals("7")) {
            bizRoles.add("SYS020");
        } else {
            bizRoles.add("SYS017");
        }
        qfilters.and("bizrole.number", "in", bizRoles);
        Set<Long> selectProjectIds = context.getProjectSet();
        if (null != selectProjectIds && selectProjectIds.size() > 0) {
            qfilters.and("project", "in", selectProjectIds);
        } else {
            qfilters.and("project.bizstatus", ">=", (Object)ProcessStatusEnums.PROCESSED.getValue());
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_memberclarify", (String)"project.id", (QFilter[])qfilters.toArray());
        Set<Long> projectIds = rows.stream().map(e -> e.getLong("project.id")).collect(Collectors.toSet());
        context.setProjectSet(projectIds);
    }
}

