/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.score.verify;

import java.math.RoundingMode;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.scm.src.common.score.SrcScoreContext;
import kd.scm.src.common.score.SrcScoreHelper;
import kd.scm.src.common.score.verify.ISrcScoreVerifyData;

public class SrcScoreVerifyInputValue
implements ISrcScoreVerifyData {
    @Override
    public void process(SrcScoreContext context) {
        this.verifyIsBlank(context);
        this.verifyIsNumber(context);
        this.verifyIndexScore(context);
    }

    protected void verifyIsBlank(SrcScoreContext context) {
        if (StringUtils.isBlank((CharSequence)context.getTxtValue())) {
            context.setVerifySucced(false);
            context.setVerifyMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bc4\u4f30\u503c\u672a\u586b\u5199\u3002", (String)"SrcScoreVerifyInputValue_0", (String)"scm-src-common", (Object[])new Object[0]), context.getCurrentRowIndex() + 1));
        }
    }

    protected void verifyIsNumber(SrcScoreContext context) {
        if (!SrcScoreHelper.isNumberValue(context.getCurrentScoreRow(), "value")) {
            try {
                context.getView().getModel().setValue("value", null, context.getCurrentRowIndex());
                context.getView().getModel().setValue("isfitted", null, context.getCurrentRowIndex());
                context.getView().getModel().setValue("note", null, context.getCurrentRowIndex());
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
            context.setVerifySucced(false);
            context.setVerifyMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bc4\u5206\u503c\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrcScoreVerifyInputValue_1", (String)"scm-src-common", (Object[])new Object[0]), context.getCurrentRowIndex() + 1));
        } else {
            String propertyValue = context.getCurrentScoreRow().getString("value");
            context.getView().getModel().setValue("value", (Object)SrcScoreHelper.formatNumberValue(propertyValue), context.getCurrentRowIndex());
        }
    }

    protected void verifyIndexScore(SrcScoreContext context) {
        if (context.getValue().multiply(context.getIndexRatio()).compareTo(context.getIndexScore()) > 0) {
            context.setVerifySucced(false);
            context.setVerifyMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u8bc4\u4f30\u503c(%2$s)\u5927\u4e8e\u6307\u6807\u5206\u503c(%3$s)\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SrcScoreVerifyInputValue_2", (String)"scm-src-common", (Object[])new Object[0]), context.getCurrentRowIndex() + 1, context.getSbValue(), context.getIndexScore().setScale(2, RoundingMode.HALF_UP)));
        }
    }
}

