/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsAptitudeUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.bidopencomm.SrcBidOpenAptOldDataDelete;
import kd.scm.src.common.util.SrcAppCache;

public class SrcAptitudeUtils {
    public static boolean isExistsUnPushConfig(IFormView view) {
        if (!SrcAptitudeUtils.isAptitudeAndSaveStatus(view)) {
            return false;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        qfilters.and("entrystatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)SrcAptitudeUtils.getAptitudeConfigF7Key(view), (QFilter[])qfilters.toArray());
    }

    public static boolean isExistsUnPushSupplier(IFormView view) {
        if (!SrcAptitudeUtils.isAptitudeAndSaveStatus(view)) {
            return false;
        }
        DynamicObject billObj = view.getModel().getDataEntity();
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        String supplierType = PdsCommonUtils.object2String((Object)billObj.get("suppliertype"), (String)"3");
        QFilter qfilters = new QFilter("billid", "=", (Object)billId);
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
        boolean isOpenBySupplier = false;
        if ("3".equals(supplierType)) {
            qfilters.and("istender", "=", (Object)"1");
            long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("srctype"));
            isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)Boolean.FALSE, (long)billId));
        }
        if ("src_aptitudeaudit".equals(view.getEntityId())) {
            qfilters.and("isaptpush", "=", (Object)"0");
            if ("3".equals(supplierType) && isOpenBySupplier) {
                qfilters.and("isaptopen", "=", (Object)"1");
            }
        } else {
            qfilters.and("isaptpush2", "=", (Object)"0");
            if ("3".equals(supplierType) && isOpenBySupplier) {
                qfilters.and("istecopen", "=", (Object)"1");
            }
        }
        if ("1".equals(supplierType)) {
            return QueryServiceHelper.exists((String)"src_enrollsupplier", (QFilter[])qfilters.toArray());
        }
        if ("2".equals(supplierType)) {
            return QueryServiceHelper.exists((String)"src_supplierinvite", (QFilter[])qfilters.toArray());
        }
        return QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])qfilters.toArray());
    }

    public static boolean isAptitudeAndSaveStatus(IFormView view) {
        if (!"src_aptitudeaudit".equals(view.getEntityId()) && !"src_aptitudeaudit2".equals(view.getEntityId())) {
            return false;
        }
        return PdsCommonUtils.isSaveStatus((DynamicObject)view.getModel().getDataEntity());
    }

    public static boolean isOpenApt(IFormView view, String openType) {
        return PdsAptitudeUtils.isOpenApt((DynamicObject)view.getModel().getDataEntity(), (String)openType);
    }

    public static boolean isExistsUnOpenApt(IFormView view, String openType) {
        long pkValue = PdsCommonUtils.object2Long((Object)view.getModel().getDataEntity().getPkValue());
        QFilter aptFilter = new QFilter("billid", "=", (Object)pkValue);
        aptFilter.and(openType, "=", (Object)false);
        if (PdsCommonUtils.isOpenBySupplier((DynamicObject)view.getModel().getDataEntity())) {
            SrcBidOpenFacade.addSupplierOpenFilter(aptFilter, !"isaptopen".equals(openType));
            return QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])aptFilter.toArray());
        }
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])aptFilter.toArray());
    }

    public static boolean isExistsAptitudeResult(IFormView view) {
        QFilter resultFilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getModel().getDataEntity()));
        return QueryServiceHelper.exists((String)SrcAptitudeUtils.getAptitudeResultF7Key(view), (QFilter[])resultFilter.toArray());
    }

    public static void saveModelData(IFormView view) {
        String billstatus = PdsCommonUtils.object2String((Object)view.getModel().getDataEntity().get("billstatus"), (String)BillStatusEnum.SAVE.getVal());
        if (BillStatusEnum.SAVE.getVal().equals(billstatus)) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)view.getModel().getDataEntity(true));
            String compPageId = SrcAppCache.get(SrcAptitudeUtils.getAptitudeConfigKey(view), String.class, view);
            IFormView compView = view.getView(compPageId);
            if (compView != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
            if ((compView = view.getView(compPageId = SrcAppCache.get(SrcAptitudeUtils.getAptitudeResultKey(view), String.class, view))) != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
            if ((compView = view.getView(compPageId = SrcAppCache.get("src_bidopen_open", String.class, view))) != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
        }
    }

    public static void pushScoreTask(IFormView view, List<DynamicObject> selectedRowDatas) {
        SrcAptitudeUtils.pushScoreTask(view, "pushaptitude", selectedRowDatas);
    }

    public static void pushScoreTask(IFormView view, String operationKey, List<DynamicObject> selectedRowDatas) {
        String msg;
        Map<String, Object> resultMap = SrcBidOpenFacade.pushScoreTask(view, view.getModel().getDataEntity(), operationKey, selectedRowDatas);
        Object succed = resultMap.get("succed");
        Object message = resultMap.get("message");
        DynamicObject billObj = view.getModel().getDataEntity();
        String string = msg = "null".equals(String.valueOf(message)) ? "" : String.valueOf(message);
        if (null != succed && ((Boolean)succed).booleanValue()) {
            if (SrcAptitudeUtils.isExistsAptitudeResult(view)) {
                if (SrcAptitudeUtils.isSupplierReplyAptitude(billObj) && "src_aptitudeaudit".equals(billObj.getDataEntityType().getName())) {
                    SrcAptitudeUtils.sendSupplierAptitudeMessage(billObj, "sendmsg");
                    view.showMessage(ResManager.loadKDString((String)"\u53d1\u9001\u8d44\u5ba1\u534f\u540c\u4efb\u52a1\u6210\u529f\uff0c\u4f9b\u5e94\u5546\u53ef\u4ee5\u8fdb\u884c\u8d44\u5ba1\u56de\u590d\u4e86\u3002", (String)"SrcAptitudeUtils_5", (String)"scm-src-common", (Object[])new Object[0]));
                } else {
                    view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8d44\u5ba1\u4efb\u52a1\u6210\u529f\u3002", (String)"SrcAptitudeUtils_0", (String)"scm-src-common", (Object[])new Object[0]));
                }
                view.invokeOperation("refresh");
            } else {
                view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8d44\u5ba1\u4efb\u52a1\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u4f9b\u5e94\u5546\u6765\u6e90\u65e0\u6548\uff0c\u6216\u8d44\u5ba1\u65b9\u6848\u65e0\u6548\uff0c\u6216\u672a\u5f00\u6807\u3002", (String)"SrcAptitudeUtils_4", (String)"scm-src-common", (Object[])new Object[0]), msg, MessageTypes.Default);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8d44\u5ba1\u4efb\u52a1\u5931\u8d25\u3002", (String)"SrcAptitudeUtils_2", (String)"scm-src-common", (Object[])new Object[0]), msg, MessageTypes.Default);
        }
    }

    public static void rePushScoreTask(IFormView view) {
        SrcAptitudeUtils.deleteScoreTask(view);
        SrcAptitudeUtils.pushScoreTask(view, Collections.emptyList());
    }

    public static void deleteScoreTask(IFormView view) {
        SrcBidOpenFacade.bidOpenCommHandle(view, SrcBidOpenAptOldDataDelete.class.getSimpleName(), SrcBidOpenAptOldDataDelete.class.getName());
    }

    public static String getAptitudeConfigKey(IFormView view) {
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            return "src_aptitudeconfig";
        }
        return "src_aptitudeconfig2";
    }

    public static String getAptitudeConfigF7Key(IFormView view) {
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            return "src_aptitudeconfigf7";
        }
        return "src_aptitudeconfig2f7";
    }

    public static String getAptitudeResultKey(IFormView view) {
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            return "src_aptituderesult";
        }
        return "src_aptituderesult2";
    }

    public static String getAptitudeResultF7Key(IFormView view) {
        if (view.getEntityId().equals("src_aptitudeaudit")) {
            return "src_aptituderesultf7";
        }
        return "src_aptituderesult2f7";
    }

    public static boolean isNeedTenderSupNumVerify(DynamicObject billObj) {
        String suppliertype;
        return !"src_aptitudeaudit".equals(billObj.getDataEntityType().getName()) && !"src_aptitudeaudit2".equals(billObj.getDataEntityType().getName()) || !"1".equals(suppliertype = billObj.getString("suppliertype")) && !"2".equals(suppliertype);
    }

    public static boolean isSupplierReplyAptitude(DynamicObject projectObj) {
        if (null == projectObj) {
            return false;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)projectObj.getDynamicObject("srctype"));
        return PdsCommonUtils.object2Boolean((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isSupplierReplyAptitude", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)projectObj)));
    }

    public static void showOrHideSupplierReply(IFormView view, DynamicObject projectObj) {
        if (null == projectObj || !SrcAptitudeUtils.isSupplierReplyAptitude(projectObj)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"publish", "aptitudereply", "aptitudereply_fj", "aptitudedate", "isaptitudereply", "puraptattach"});
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"publish", "aptitudereply", "aptitudereply_fj", "aptitudedate", "isaptitudereply", "puraptattach"});
            if ("src_aptitudeaudit".equals(view.getEntityId())) {
                if (SrcAptitudeUtils.isOpenApt(view, "isaptopen")) {
                    view.setVisible(Boolean.valueOf(false), new String[]{"publish"});
                }
                view.setVisible(Boolean.valueOf(false), new String[]{"repushaptitude"});
            }
        }
    }

    public static void loadAptitudeReplyAttach(IFormView view, String entryName, String entryidName) {
        DynamicObjectCollection sourceRows = view.getModel().getDataEntity().getDynamicObjectCollection(entryName);
        if (null == sourceRows || sourceRows.size() == 0) {
            return;
        }
        Set entryIdSet = sourceRows.stream().map(e -> e.getLong(entryidName)).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", entryIdSet);
        qfilter.and(new QFilter("billid.cfmstatus", "=", (Object)"C").or("entrystatus", ">=", (Object)"B"));
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask_indexf7", (String)"aptitudereply,aptitudereply_fj", (QFilter[])qfilter.toArray());
        if (null == rows || rows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> replyMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        for (int rowIndex = 0; rowIndex < model.getEntryRowCount(entryName); ++rowIndex) {
            DynamicObject row = model.getEntryEntity(entryName, rowIndex);
            DynamicObject replyObj = replyMap.get(row.getLong(entryidName));
            if (null == replyObj) continue;
            model.setValue("aptitudereply", replyObj.get("aptitudereply"), rowIndex);
            MultiBasedataUtils.setMultiBasedataForModel((IDataModel)model, (DynamicObject)replyObj, (String)"aptitudereply_fj", (int)rowIndex);
        }
        model.endInit();
        view.updateView(entryName);
    }

    public static void sendSupplierAptitudeMessage(DynamicObject billObj, String operation) {
        long billId = PdsCommonUtils.object2Long((Object)billObj.getPkValue());
        QFilter qfilter = new QFilter("project", "=", (Object)billId);
        qfilter.and("cfmstatus", "=", (Object)"A");
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"tnd_aptitude", (String)"id", (QFilter[])qfilter.toArray());
        if (rows == null || rows.size() == 0) {
            return;
        }
        Long[] billIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
        PdsCommonUtils.doOperation((String)"tnd_aptitude", (Long[])billIds, (String)operation, null);
    }
}

