/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcBidAssessUtils {
    public static boolean isNeedExcludeBizIndex(IFormView view) {
        if (SrcBidAssessUtils.isManualscore(view)) {
            return true;
        }
        return SrcBidAssessUtils.isNeedBizOpenControl(view.getModel().getDataEntity()) && !SrcBidAssessUtils.isBizOpened(view);
    }

    public static boolean isNeedExcludeBizIndex(DynamicObject billObj) {
        if (SrcBidAssessUtils.isManualscore(billObj)) {
            return true;
        }
        return SrcBidAssessUtils.isNeedBizOpenControl(billObj) && !SrcBidAssessUtils.isBizOpened(billObj);
    }

    public static boolean isNeedBizOpenControl(DynamicObject billObj) {
        long sourceFlowId = 0L;
        long projectId = 0L;
        if ("src_projectf7".equals(billObj.getDataEntityType().getName())) {
            sourceFlowId = billObj.getLong("srctype.id");
            projectId = billObj.getLong("id");
        } else {
            sourceFlowId = billObj.getLong("projectf7.srctype.id");
            projectId = billObj.getLong("projectf7.id");
        }
        return ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isneedbizopencontrol", (Object)true, (long)projectId));
    }

    public static boolean isTecOrBizOpened(long projectId, String openType) {
        QFilter qfilters = new QFilter("billid", "=", (Object)projectId);
        qfilters.and(openType, "=", (Object)"1");
        if (QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])qfilters.toArray())) {
            return true;
        }
        return QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])qfilters.toArray());
    }

    public static boolean isTecOpened(IFormView view) {
        return SrcBidAssessUtils.isTecOrBizOpened(SrmCommonUtil.getPkValue((DynamicObject)view.getParentView().getModel().getDataEntity()), "istecopen");
    }

    public static boolean isTecOpened(DynamicObject billObj) {
        return SrcBidAssessUtils.isTecOrBizOpened(SrmCommonUtil.getPkValue((DynamicObject)billObj), "istecopen");
    }

    public static boolean isTecOpened(long projectId) {
        return SrcBidAssessUtils.isTecOrBizOpened(projectId, "istecopen");
    }

    public static boolean isBizOpened(IFormView view) {
        return SrcBidAssessUtils.isTecOrBizOpened(SrmCommonUtil.getPkValue((DynamicObject)view.getParentView().getModel().getDataEntity()), "isbizopen");
    }

    public static boolean isBizOpened(DynamicObject billObj) {
        return SrcBidAssessUtils.isTecOrBizOpened(SrmCommonUtil.getPkValue((DynamicObject)billObj), "isbizopen");
    }

    public static boolean isBizOpened(long projectId) {
        return SrcBidAssessUtils.isTecOrBizOpened(projectId, "isbizopen");
    }

    public static boolean isManualscore(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        return billObj.getBoolean("ismanualscore");
    }

    public static boolean isManualscore(DynamicObject billObj) {
        boolean isManualscore;
        block2: {
            isManualscore = false;
            try {
                isManualscore = billObj.getBoolean("ismanualscore");
            }
            catch (Exception e) {
                QFilter qfilters = new QFilter("id", "=", billObj.getPkValue());
                DynamicObject openCfgObj = QueryServiceHelper.queryOne((String)"src_bidopen_config", (String)"ismanualscore", (QFilter[])qfilters.toArray());
                if (null == openCfgObj) break block2;
                return openCfgObj.getBoolean("ismanualscore");
            }
        }
        return isManualscore;
    }

    public static QFilter getProjectFilter(IFormView view) {
        return new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)view.getParentView().getModel().getDataEntity()));
    }

    public static QFilter getProjectFilter(DynamicObject billObj) {
        return new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
    }

    public static void setUnFinishScorer(IFormView view) {
        String entityName = "src_scoreanalyse";
        if (view.getEntityId().equals("src_evaluateresult")) {
            entityName = "src_evaluateanalyse";
        }
        long projectId = (Long)view.getParentView().getModel().getDataEntity().getPkValue();
        QFilter qfilter = new QFilter("project", "=", (Object)projectId).and("scored", "=", (Object)"0");
        qfilter.and("billid.bizstatus", "!=", (Object)"E");
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)"billid,scorer", (QFilter[])qfilter.toArray());
        Map<Long, List<DynamicObject>> scoreMap = Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("billid.id")));
        DynamicObjectCollection entrys = view.getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject entry : entrys) {
            long billId = entry.getLong("scoretask.id");
            List<DynamicObject> scoretaskList = scoreMap.get(billId);
            if (null != scoretaskList) {
                List scorerList = scoretaskList.stream().map(e -> e.getDynamicObject("scorer")).collect(Collectors.toList());
                DynamicObjectCollection scorers = new DynamicObjectCollection();
                scorers.addAll(scorerList);
                MultiBasedataUtils.setMultiBasedataForModel((IDataModel)view.getModel(), (DynamicObjectCollection)scorers, (String)"scorer", (int)index);
            }
            ++index;
        }
    }

    public static String getUnFinishScorer(long projectId, Set<String> baseTypes) {
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        qfilter.and("scored", "=", (Object)"0");
        qfilter.and("billid.bizstatus", "!=", (Object)"E");
        if (null != baseTypes && baseTypes.size() > 0) {
            qfilter.and("billid.basetype", "in", baseTypes);
        }
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoreanalyse", (String)"billid,scorer", (QFilter[])qfilter.toArray());
        return Arrays.stream(rows).map(e -> e.getDynamicObject("scorer")).distinct().map(e -> e.getString("name")).collect(Collectors.joining("\u3001"));
    }

    public static String getUnFinishScorer(long projectId) {
        return SrcBidAssessUtils.getUnFinishScorer(projectId, null);
    }

    public static boolean isFinalValue(IDataModel model) {
        if (model.getDataEntity().getBoolean("isbyproject")) {
            return false;
        }
        String scoreMethod = PdsCommonUtils.object2String((Object)model.getValue("scoremethod"), (String)"");
        return "3".equals(scoreMethod);
    }

    public static void openBidAssessResult(IFormView view) {
        long projectId = PdsCommonUtils.object2Long((Object)view.getModel().getDataEntity().getPkValue());
        HashMap<String, Long> paramMap = new HashMap<String, Long>(2);
        paramMap.put("projectid", projectId);
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        OpenFormUtils.openListPage((IFormView)view, (String)"src_bidassess_biz", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)qfilter, null);
    }

    public static void openBidAssessResultLog(IFormView view) {
        long projectId = PdsCommonUtils.object2Long((Object)PdsCommonUtils.getCustomParamValue((IFormView)view, (String)"projectid"));
        if (projectId > 0L) {
            QFilter qFilter = new QFilter("projectf7", "=", (Object)projectId);
            OpenFormUtils.openListPage((IFormView)view, (String)"src_bidassess_log", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
        }
    }

    public static boolean isParallelOpenTec(String openType, String entityName) {
        if (!"4".equals(openType)) {
            return false;
        }
        return "src_bidassess".equals(entityName);
    }

    public static boolean isParallelOpenTec(DynamicObject billObj) {
        return SrcBidAssessUtils.isParallelOpenTec(billObj.getString("opentype"), billObj.getDataEntityType().getName());
    }

    public static boolean isParallelOpenBiz(String openType, String entityName) {
        if (!"4".equals(openType)) {
            return false;
        }
        return "src_compare".equals(entityName);
    }

    public static boolean isParallelOpenBiz(DynamicObject billObj) {
        return SrcBidAssessUtils.isParallelOpenBiz(billObj.getString("opentype"), billObj.getDataEntityType().getName());
    }

    public static boolean isNeedIndexTypeControl(DynamicObject billObj) {
        String entityName = billObj.getDataEntityType().getName();
        if (!"src_bidassess".equals(entityName) && !"src_compare".equals(entityName)) {
            return false;
        }
        long sourceFlowId = billObj.getLong("projectf7.srctype.id");
        long projectId = billObj.getLong("projectf7.id");
        return ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isNeedIndexTypeControl", (Object)false, (long)projectId));
    }
}

