/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.util.PdsCommonUtils;

public class SrcBidSummaryUtils {
    public static boolean isValid(String property, DynamicObject obj) {
        boolean isValid = false;
        isValid = property.equals("isvalid") ? (obj.getBoolean("isquote") || obj.getBoolean("istender")) && !obj.getBoolean("isdiscard") && !obj.getString("isaptitude").equals("2") : obj.getBoolean(property);
        return isValid;
    }

    public static void summaryAndDisplay(IDataModel dataModel, String suffix, String entryEntity) {
        ArrayList<String> propertys = new ArrayList<String>(7);
        SrcBidSummaryUtils.setPropertys(propertys);
        HashSet<String> packageSet = new HashSet<String>();
        HashMap<String, Integer> summaryMap = new HashMap<String, Integer>();
        SrcBidSummaryUtils.summary("src_enrollsupplier", dataModel, packageSet, summaryMap, propertys);
        SrcBidSummaryUtils.summary("src_bidopensupplier", dataModel, packageSet, summaryMap, propertys);
        SrcBidSummaryUtils.display(dataModel, packageSet, summaryMap, propertys, entryEntity, suffix);
    }

    public static void setPropertys(List<String> propertys) {
        propertys.clear();
        propertys.add("isvalid");
        propertys.add("isenroll");
        propertys.add("isinvite");
        propertys.add("ispayfee");
        propertys.add("isconfirm");
        propertys.add("istender");
        propertys.add("isquote");
        propertys.add("isdiscard");
        propertys.add("isnegotiate");
    }

    public static void summary(String entityName, IDataModel dataModel, Set<String> packageSet, Map<String, Integer> summaryMap, List<String> propertys) {
        long billId = PdsCommonUtils.object2Long((Object)dataModel.getDataEntity().getPkValue());
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)entityName, (boolean)true);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"package");
        if (objs == null || objs.size() == 0) {
            return;
        }
        for (DynamicObject obj : objs) {
            String packageId = SrcBidSummaryUtils.getPackageId(obj, billId);
            if (null == packageId) {
                return;
            }
            packageSet.add(packageId);
            for (String property : propertys) {
                if ("isenroll".equals(property) && "src_bidopensupplier".equals(entityName) || !"isenroll".equals(property) && "src_enrollsupplier".equals(entityName)) continue;
                String key_property = packageId + "_" + property;
                int count = 0;
                if (summaryMap.get(key_property) != null) {
                    count = summaryMap.get(key_property);
                }
                boolean isValid = "src_enrollsupplier".equals(entityName) ? true : SrcBidSummaryUtils.isValid(property, obj);
                summaryMap.put(key_property, count + (isValid ? 1 : 0));
            }
        }
    }

    public static void display(IDataModel dataModel, Set<String> packageSet, Map<String, Integer> summaryMap, List<String> propertys, String entryEntity, String suffix) {
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData(entryEntity);
        if (packageSet == null || packageSet.size() == 0) {
            return;
        }
        if (summaryMap == null || summaryMap.size() == 0) {
            return;
        }
        Set<Object> packageIdSet = new HashSet();
        long billId = PdsCommonUtils.object2Long((Object)dataModel.getDataEntity().getPkValue());
        QFilter filters = new QFilter("billid", "=", (Object)billId);
        DynamicObjectCollection bidopenpackageCols = QueryServiceHelper.query((String)"src_bidopenpackage", (String)"package", (QFilter[])filters.toArray());
        if (bidopenpackageCols != null) {
            packageIdSet = bidopenpackageCols.stream().map(row -> row.getString("package")).collect(Collectors.toSet());
        }
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        for (String key : packageSet) {
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)key) && !packageIdSet.contains(key)) continue;
            ts.set("package" + suffix, (Object)key, i);
            for (String property : propertys) {
                String key_property = key + "_" + property;
                ts.set(property + suffix, (Object)summaryMap.get(key_property), i);
            }
            ++i;
        }
        model.batchCreateNewEntryRow(entryEntity, ts);
    }

    public static String getPackageId(DynamicObject obj, long billId) {
        String packageId = obj.getString("package");
        if ("0".equals(packageId)) {
            DynamicObject packageObj = PdsCommonUtils.getNoPackageNameObj((long)billId);
            if (null == packageObj) {
                return null;
            }
            packageId = packageObj.getString("package.id");
        }
        return packageId;
    }
}

