/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.src.common.util.SrcAppCache;

public class SrcDecisionUtil {
    public static boolean isDecisionConfirm(DynamicObject billObj, boolean isComponent) {
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        if (isComponent) {
            long parentId = billObj.getLong("parentid");
            qFilter.or("id", "=", (Object)parentId);
        }
        qFilter = qFilter.and("cfmstatus", "=", (Object)"B");
        return QueryServiceHelper.exists((String)"src_decision", (QFilter[])new QFilter[]{qFilter});
    }

    public static void setSubEntryEntityAmount(IDataModel model, int index, DynamicObject obj, BigDecimal newValue, String keyName) {
        model.setEntryCurrentRowIndex("entryentity", index);
        DynamicObjectCollection subObjs = obj.getDynamicObjectCollection("subentryentity");
        for (int i = 0; i < subObjs.size(); ++i) {
            model.setValue(keyName, (Object)((DynamicObject)subObjs.get(i)).getBigDecimal("signrate").multiply(newValue).divide(new BigDecimal(100)), i);
        }
    }

    public static void clearSumTaxAmount(IFormView iFormView) {
        IFormView parentView = iFormView.getParentView();
        if (Objects.isNull(parentView)) {
            return;
        }
        if (parentView.getModel().getDataEntity().getBoolean("isedited")) {
            return;
        }
        parentView.getModel().setValue("sumtaxamount", (Object)0);
        parentView.getModel().setValue("sumamount", (Object)0);
        parentView.getModel().setValue("isedited", (Object)Boolean.TRUE);
        parentView.getModel().setDataChanged(false);
        iFormView.sendFormAction(parentView);
    }

    public static void saveAmount(IFormView iFormView, IDataModel iDataModel) {
        String supPageId = SrcAppCache.get("src_decisionsum_sup", String.class, iFormView);
        if (StringUtils.isBlank((CharSequence)supPageId)) {
            return;
        }
        IFormView supFormView = iFormView.getView(supPageId);
        if (null == supFormView) {
            return;
        }
        DynamicObject obj = supFormView.getModel().getDataEntity(true);
        String sumType = obj.getString("sumtype");
        if (Objects.equals(sumType, "2") && !iDataModel.getDataEntity().getBoolean("isedited")) {
            BigDecimal sumAmount;
            DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
            BigDecimal sumTaxAmount = rows.stream().map(row -> row.getBigDecimal("taxamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (sumTaxAmount.compareTo(BigDecimal.ZERO) != 0) {
                iDataModel.setValue("sumtaxamount", (Object)sumTaxAmount);
            }
            if ((sumAmount = rows.stream().map(row -> row.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) != 0) {
                iDataModel.setValue("sumamount", (Object)sumAmount);
            }
        }
    }

    public static void deleteDefaultvauleLog(long projectId) {
        QFilter qfilter = new QFilter("billid", "=", (Object)projectId);
        DeleteServiceHelper.delete((String)"pds_setdefaultvaule", (QFilter[])qfilter.toArray());
    }
}

