/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.src.common.bidopen.SrcBidOpenFacade;
import kd.scm.src.common.bidopen.bidopencomm.SrcEvaluateOldDataDelete;
import kd.scm.src.common.util.SrcAppCache;

public class SrcEvaluateUtils {
    public static boolean isExistsUnPushConfig(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        if (!PdsCommonUtils.isSaveStatus((DynamicObject)billObj)) {
            return false;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        qfilters.and("entrystatus", "=", (Object)"A");
        return QueryServiceHelper.exists((String)"src_evaluateconfigf7", (QFilter[])qfilters.toArray());
    }

    public static boolean isExistsUnPushExpert(IFormView view) {
        DynamicObject billObj = view.getModel().getDataEntity();
        if (!PdsCommonUtils.isSaveStatus((DynamicObject)billObj)) {
            return false;
        }
        QFilter qfilters = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)billObj));
        qfilters.and("isevaluatepush", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"src_evaluateexpertf7", (QFilter[])qfilters.toArray());
    }

    public static boolean isExistsEvaluateResult(IFormView view) {
        QFilter resultFilter = new QFilter("billid", "=", (Object)view.getModel().getDataEntity().getLong("id"));
        return QueryServiceHelper.exists((String)"src_evaluateresultf7", (QFilter[])resultFilter.toArray());
    }

    public static void setPushButtonVisible(IFormView view) {
        boolean isPushEvaluate = SrcEvaluateUtils.isExistsUnPushConfig(view) || SrcEvaluateUtils.isExistsUnPushExpert(view);
        view.setVisible(Boolean.valueOf(isPushEvaluate), new String[]{"pushevaluate"});
        view.setVisible(Boolean.valueOf(!isPushEvaluate), new String[]{"unpushevaluate"});
        view.setVisible(Boolean.valueOf(!isPushEvaluate), new String[]{"evaluatehelper", "evaluateanalyse"});
    }

    public static void saveModelData(IFormView view) {
        String billstatus = PdsCommonUtils.object2String((Object)view.getModel().getDataEntity().get("billstatus"), (String)BillStatusEnum.SAVE.getVal());
        if (BillStatusEnum.SAVE.getVal().equals(billstatus)) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)view.getModel().getDataEntity(true));
            String compPageId = SrcAppCache.get("src_evaluateconfig", String.class, view);
            IFormView compView = view.getView(compPageId);
            if (compView != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
            if ((compView = view.getView(compPageId = SrcAppCache.get("src_evaluateexpert", String.class, view))) != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
            if ((compView = view.getView(compPageId = SrcAppCache.get("src_evaluateresult", String.class, view))) != null) {
                PdsCommonUtils.saveDynamicObjects((DynamicObject)compView.getModel().getDataEntity(true));
            }
        }
    }

    public static void pushEvaluateTask(IFormView view, List<DynamicObject> selectedRowDatas) {
        String msg;
        Map<String, Object> resultMap = SrcBidOpenFacade.pushScoreTask(view, view.getModel().getDataEntity(), "pushevaluate", selectedRowDatas);
        Object succed = resultMap.get("succed");
        Object message = resultMap.get("message");
        String string = msg = "null".equals(String.valueOf(message)) ? "" : String.valueOf(message);
        if (null != succed && ((Boolean)succed).booleanValue()) {
            if (SrcEvaluateUtils.isExistsEvaluateResult(view)) {
                view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8003\u8bc4\u4efb\u52a1\u6210\u529f\u3002", (String)"SrcEvaluateUtils_0", (String)"scm-src-common", (Object[])new Object[0]));
                view.invokeOperation("refresh");
                long billId = view.getModel().getDataEntity().getLong("id");
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(false));
                option.setVariableValue("ishasright", String.valueOf(true));
                OperationServiceHelper.executeOperate((String)"evaluatetasksendmsg", (String)"src_expertevaluate", (Object[])new Long[]{billId}, (OperateOption)option);
            } else {
                view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8003\u8bc4\u4efb\u52a1\u5931\u8d25\uff0c\u672a\u751f\u6210\u8003\u8bc4\u4efb\u52a1\uff0c\u53ef\u80fd\u662f\u5f85\u8003\u8bc4\u4e13\u5bb6\u4e3a\u7a7a\uff0c\u6216\u8003\u8bc4\u8bbe\u7f6e\u4e3a\u7a7a\u3002", (String)"SrcEvaluateUtils_1", (String)"scm-src-common", (Object[])new Object[0]), msg, MessageTypes.Default);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u4e0b\u8fbe\u8003\u8bc4\u4efb\u52a1\u5931\u8d25\u3002", (String)"SrcEvaluateUtils_2", (String)"scm-src-common", (Object[])new Object[0]), msg, MessageTypes.Default);
        }
    }

    public static void unPushEvaluateTask(IFormView view) {
        SrcEvaluateUtils.deleteEvaluateTask(view);
    }

    public static void deleteEvaluateTask(IFormView view) {
        ExtPluginContext context = new ExtPluginContext();
        context.setView(view);
        ExtPluginFactory.executeExtplugin((String)SrcEvaluateOldDataDelete.class.getSimpleName(), (ExtPluginContext)context, (boolean)true, (String)SrcEvaluateOldDataDelete.class.getName());
    }

    public static long getScoreGrade(Map<Long, DynamicObject> gradeMap, long gradeId, BigDecimal score) {
        if (gradeId == 0L) {
            return 0L;
        }
        DynamicObject gradeObj = gradeMap.get(gradeId);
        if (null == gradeObj) {
            gradeObj = BusinessDataServiceHelper.loadSingle((Object)gradeId, (String)"src_expertgrade");
            if (gradeObj == null) {
                return 0L;
            }
            gradeMap.put(gradeId, gradeObj);
        }
        DynamicObjectCollection rows = gradeObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject row : rows) {
            if (score.compareTo(row.getBigDecimal("scorefrom")) <= 0 || score.compareTo(row.getBigDecimal("scoreto")) > 0) continue;
            return row.getLong("grade.id");
        }
        return 0L;
    }

    public static void updateEvaluateGrade(DynamicObject[] rows, String gradeField, String schemeField, String scoreField) {
        if (null == rows || rows.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> gradeMap = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject row : rows) {
            row.set(gradeField, (Object)SrcEvaluateUtils.getScoreGrade(gradeMap, row.getLong(schemeField), row.getBigDecimal(scoreField)));
        }
    }

    public static void updateExpertPushStatus(long projectId, boolean isPush) {
        QFilter qFilter = new QFilter("id", "=", (Object)projectId);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((String)"src_expertevaluate", (String)"isevaluatepush", (QFilter[])qFilter.toArray());
        if (null != billObj) {
            billObj.set("isevaluatepush", (Object)isPush);
            PdsCommonUtils.saveDynamicObjects((DynamicObject)billObj);
        }
    }
}

