/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pds.common.validator.ISrcValidator;

public class SrcMustInputValidatorFactory {
    public static ISrcValidator getService(Object configId) {
        String plugin = SrcMustInputValidatorFactory.getValidatePluginByCompConfig(configId);
        ISrcValidator validator = null;
        if (plugin != null && plugin.trim().length() > 0) {
            try {
                validator = (ISrcValidator)Class.forName(plugin).newInstance();
            }
            catch (InstantiationException e) {
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        return validator;
    }

    public static String getValidatePluginByCompConfig(Object configId) {
        String plugin = null;
        DynamicObject compConfigObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(configId.toString()), (String)"pds_compconfig", (String)"validatorplugin");
        if (null != compConfigObj) {
            plugin = compConfigObj.getString("validatorplugin");
        }
        return plugin;
    }
}

