/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.IPdsQuoteRefresh;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.src.common.vie.ISrcQuoteRefreshFromDB;
import kd.scm.src.common.vie.SrcVieFactory;

public class SrcQuoteRefreshFromDB
implements ISrcQuoteRefreshFromDB {
    public IPdsQuoteRefresh getData(PdsVieContext context) {
        SrcVieFactory.getSrcQuoteRankFromDB().getData(context);
        return this;
    }

    public IPdsQuoteRefresh handleData(PdsVieContext context) {
        SrcVieFactory.getSrcQuoteRankFromDB().rankData(context);
        return this;
    }

    public void refreshData(PdsVieContext context) {
        this.refreshQuoteRank(context);
    }

    protected void refreshQuoteRank(PdsVieContext context) {
        Map quoteRank = context.getQuoteRank();
        if (quoteRank == null || quoteRank.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)context.getView().getModel();
        DynamicObjectCollection rows = model.getEntryEntity("entryentity");
        List properties = context.getExtProperties();
        HashSet excludedFields = new HashSet();
        int rowIndex = 0;
        model.beginInit();
        for (DynamicObject row : rows) {
            StringBuilder key = new StringBuilder();
            key.append(row.getString("purlist.id"));
            key.append('|');
            key.append(row.getString("supplier.id"));
            Map rankMap = (Map)quoteRank.get(key.toString());
            if (rankMap != null && rankMap.size() > 0) {
                this.setOptimalValue((IDataModel)model, rankMap, rowIndex);
                this.setOtherValue((IDataModel)model, rankMap, rowIndex);
                if (null != properties && properties.size() > 0) {
                    PdsCommonUtils.copyDynamicObjectValue((DynamicObject)((DynamicObject)rankMap.get("supplierquote")), (List)properties, excludedFields, (IDataModel)model, (int)rowIndex);
                }
            }
            ++rowIndex;
        }
        model.endInit();
        context.getView().updateView("entryentity");
    }

    protected void setOptimalValue(IDataModel model, Map<String, Object> rankMap, int rowIndex) {
        model.setValue("rank", rankMap.get("rank"), rowIndex);
        model.setValue("pkgrank", rankMap.get("pkgrank"), rowIndex);
        model.setValue("pkgamount", rankMap.get("pkgamount"), rowIndex);
        model.setValue("pkgtaxamount", rankMap.get("pkgtaxamount"), rowIndex);
        model.setValue("prorank", rankMap.get("prorank"), rowIndex);
        model.setValue("proamount", rankMap.get("proamount"), rowIndex);
        model.setValue("protaxamount", rankMap.get("protaxamount"), rowIndex);
        DynamicObject optimalQuote = (DynamicObject)rankMap.get("optimalquote");
        model.setValue("optimalprice", optimalQuote.get("locprice"), rowIndex);
        model.setValue("optimaltaxprice", optimalQuote.get("loctaxprice"), rowIndex);
        model.setValue("optimalamount", optimalQuote.get("locamount"), rowIndex);
        model.setValue("optimaltaxamount", optimalQuote.get("loctaxamount"), rowIndex);
        model.setValue("optimalsupplier", optimalQuote.get("supplier"), rowIndex);
    }

    protected void setOtherValue(IDataModel model, Map<String, Object> rankMap, int rowIndex) {
        DynamicObject supplierQuote = (DynamicObject)rankMap.get("supplierquote");
        model.setValue("price", supplierQuote.get("price"), rowIndex);
        model.setValue("taxprice", supplierQuote.get("taxprice"), rowIndex);
        model.setValue("taxitem", supplierQuote.get("taxitem"), rowIndex);
        model.setValue("taxrate", supplierQuote.get("taxrate"), rowIndex);
        model.setValue("amount", supplierQuote.get("amount"), rowIndex);
        model.setValue("taxamount", supplierQuote.get("taxamount"), rowIndex);
        model.setValue("currency", supplierQuote.get("currency"), rowIndex);
        model.setValue("note", supplierQuote.get("note"), rowIndex);
        model.setValue("vieratio", supplierQuote.get("vieratio"), rowIndex);
        model.setValue("viediffer", supplierQuote.get("viediffer"), rowIndex);
        model.setValue("restofbidcount2", supplierQuote.get("restofbidcount"), rowIndex);
        model.setValue("ispresent", supplierQuote.get("ispresent"), rowIndex);
        model.setValue("isdiscarded", supplierQuote.get("isdiscarded"), rowIndex);
        model.setValue("quotedate", supplierQuote.get("quotedate"), rowIndex);
        model.setValue("costdetail", supplierQuote.get("costdetail"), rowIndex);
    }
}

