/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.Date;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.ISrcVieAddtime;

public class SrcVieAddtime
implements ISrcVieAddtime {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        DynamicObject vieBillObj = context.getVieBillObj();
        if (vieBillObj == null) {
            return;
        }
        long lastTime = vieBillObj.getLong("lasttime");
        long delayTime = vieBillObj.getLong("delaytime");
        if (lastTime == 0L || delayTime == 0L) {
            return;
        }
        int addtimeNum = vieBillObj.getInt("addtimenum");
        int addtimeCount = vieBillObj.getInt("addtimecount");
        if (addtimeNum > 0 && addtimeCount >= addtimeNum) {
            context.setMessage(String.format(ResManager.loadKDString((String)"\u672c\u8f6e\u7d2f\u8ba1\u8865\u8ba1\u65f6\u6b21\u6570(%1$s) \u2265 \u6bcf\u8f6e\u6700\u591a\u8865\u8ba1\u65f6\u6b21\u6570(%2$s)\uff0c\u4e0d\u80fd\u518d\u8865\u8ba1\u65f6\u3002", (String)"SrcVieAddtime_0", (String)"scm-src-common", (Object[])new Object[0]), addtimeCount, addtimeNum));
            return;
        }
        long addTime = vieBillObj.getLong("addtime");
        Date lastQuoteDate = vieBillObj.getDate("lastquotedate");
        Date newQuoteDate = this.getNewQuoteDate(context, lastQuoteDate);
        if (null == newQuoteDate) {
            return;
        }
        if (lastQuoteDate == null || newQuoteDate.after(lastQuoteDate)) {
            context.setTimeoutTimes(PdsVieHelper.getRestOfTime((PdsVieContext)context));
            long remainTime = TimeServiceHelper.now().getTime() + context.getTimeoutTimes() - newQuoteDate.getTime() - 1000L;
            if (remainTime < lastTime * 60L * 1000L && this.saveLastQuoteDate(vieBillObj, addTime, delayTime, newQuoteDate).booleanValue()) {
                context.setAddTime(Boolean.TRUE.booleanValue());
            }
        }
    }

    protected Date getNewQuoteDate(PdsVieContext context, Date lastQuoteDate) {
        Date newQuote = null;
        if (context.getVieTechScheme().equals("1")) {
            newQuote = this.getLastQuoteFromDB(context);
        }
        return newQuote;
    }

    protected Boolean saveLastQuoteDate(DynamicObject vieBillObj, long addTime, long delayTime, Date newQuoteDate) {
        vieBillObj.set("addtime", (Object)(addTime + delayTime));
        vieBillObj.set("addtimecount", (Object)(vieBillObj.getInt("addtimecount") + 1));
        vieBillObj.set("lastquotedate", (Object)newQuoteDate);
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{vieBillObj});
        if (null != result && result.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Date getLastQuoteFromDB(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId()).and("turns", "=", (Object)context.getTurns()).and("vieturns", "=", (Object)context.getVieturns());
        DynamicObjectCollection lastQuotes = QueryServiceHelper.query((String)"src_vie_detailf7", (String)"bidcount,quotedate", (QFilter[])qfilter.toArray(), (String)"quotedate desc", (int)1);
        if (lastQuotes != null && lastQuotes.size() > 0) {
            return ((DynamicObject)lastQuotes.get(0)).getDate("quotedate");
        }
        return null;
    }

    public DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(RequestContext.get().getTenantId() + "_" + "src");
    }
}

