/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.vie;

import java.util.HashMap;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.bizop.PdsBizOperateLogUtils;
import kd.scm.pds.common.util.ComboEditUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.src.common.vie.ISrcVieAuthorityVerify;

public class SrcVieHandleLogRecord
implements ISrcVieAuthorityVerify {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = this.buildLogInfo(context);
        logService.addLog(logInfo);
        Set supplierIds = PdsVieHelper.getAllVieSupplierIdSet((long)context.getProjectId(), (String)context.getTurns());
        DynamicObject logObj = this.recordBizOpLog(context, supplierIds);
        context.setBillId(PdsCommonUtils.object2Long((Object)logObj.getPkValue()));
        PdsVieHelper.setAllSupplierVieMessage((PdsVieContext)context, (Set)supplierIds, (long)context.getBillId());
    }

    protected AppLogInfo buildLogInfo(PdsVieContext context) {
        DynamicObject billObj = context.getView().getModel().getDataEntity();
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(PdsCommonUtils.getLoginIp());
        logInfo.setBizAppID("0DUM2+6E41IA");
        logInfo.setBizObjID("src_vie_online");
        Long orgId = context.getVieBillObj().getLong("org.id");
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        if ("src_vie_exception".equals(context.getView().getEntityId())) {
            String opName = ComboEditUtils.getComboKeyByValue((DynamicObject)context.getView().getModel().getDataEntity(), (String)"result", (String)context.getHandleType());
            logInfo.setOpName(opName);
            logInfo.setOpDescription(billObj.getString("opinion"));
        } else if ("E".equals(context.getHandleType())) {
            logInfo.setOpName(ResManager.loadKDString((String)"\u7ade\u4ef7\u542f\u52a8", (String)"SrcVieHandleLogRecord_0", (String)"scm-src-common", (Object[])new Object[0]));
            logInfo.setOpDescription(ResManager.loadKDString((String)"\u91cd\u65b0\u542f\u52a8\u7ade\u4ef7", (String)"SrcVieHandleLogRecord_4", (String)"scm-src-common", (Object[])new Object[0]));
        }
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        return logInfo;
    }

    public DynamicObject recordBizOpLog(PdsVieContext context, Set<Long> supplierIds) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        DynamicObject billObj = context.getView().getModel().getDataEntity();
        paramMap.put("project", context.getProjectId());
        paramMap.put("billid", context.getProjectId());
        paramMap.put("entitykey", context.getVieBillObj().getDataEntityType().getName());
        paramMap.put("supplier", supplierIds);
        paramMap.put("turns", context.getTurns());
        paramMap.put("vieturns", context.getVieturns());
        paramMap.put("opkey", context.getHandleType());
        String opName = null;
        String description = "";
        if ("src_vie_exception".equals(context.getView().getEntityId())) {
            opName = ComboEditUtils.getComboKeyByValue((DynamicObject)context.getView().getModel().getDataEntity(), (String)"result", (String)context.getHandleType());
            description = billObj.getString("opinion");
        } else if ("E".equals(context.getHandleType())) {
            opName = ResManager.loadKDString((String)"\u7ade\u4ef7\u542f\u52a8", (String)"SrcVieHandleLogRecord_0", (String)"scm-src-common", (Object[])new Object[0]);
            description = ResManager.loadKDString((String)"\u91cd\u65b0\u542f\u52a8\u7ade\u4ef7", (String)"SrcVieHandleLogRecord_4", (String)"scm-src-common", (Object[])new Object[0]);
        }
        paramMap.put("optype", opName);
        StringBuilder sb = new StringBuilder(description);
        if ("F".equals(context.getHandleType())) {
            sb.append('\n').append(ResManager.loadKDString((String)"\u7ade\u4ef7\u5ef6\u957f\u65f6\u95f4: ", (String)"SrcVieHandleLogRecord_5", (String)"scm-src-common", (Object[])new Object[0])).append(context.getView().getModel().getDataEntity().getString("delaytime")).append(ResManager.loadKDString((String)"(\u5206\u949f)", (String)"SrcVieHandleLogRecord_3", (String)"scm-src-common", (Object[])new Object[0]));
        }
        paramMap.put("reason", sb.toString());
        return PdsBizOperateLogUtils.recordBizOpLog(paramMap);
    }
}

