/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.src.common.warn;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.extfilter.ExtFilterContext;
import kd.scm.pds.common.extfilter.IExtFilterPlugin;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class SrcEarlyWarnViePlanOpenDateFilter
implements IExtFilterPlugin<ExtFilterContext> {
    private static final long serialVersionUID = 1L;

    public Map<String, Object> getQFilter(ExtFilterContext context) {
        String number = (String)context.getParamMap().get("number");
        DynamicObject extFilterObj = ExtParameterUtils.getExtParameterObjByNumber((String)"pds_extfilter", (String)number);
        if (extFilterObj == null) {
            return null;
        }
        String earlyWarn = String.valueOf(ExtParameterUtils.getExtParameterValueByNumber((String)"pds_extfilter", (String)number, (String)"earlywarn", (Object)"24,48"));
        if (StringUtils.isBlank((CharSequence)earlyWarn)) {
            return null;
        }
        String entityName = extFilterObj.getString("basedata.number");
        String planOpenDate = "planopendate";
        if ("tnd_tenderbill".equals(entityName) || "tnd_quotebill".equals(entityName)) {
            planOpenDate = "project.planopendate";
        }
        Date currentDate = TimeServiceHelper.now();
        QFilter allQfilter = null;
        int offsets = Integer.parseInt(ExtParameterUtils.getExtParameterValueByNumber((String)"pds_extfilter", (String)number, (String)"offsettimes", (Object)35).toString());
        String[] earlyWarns = earlyWarn.split("[:,\uff0c;]");
        for (int i = 0; i < earlyWarns.length; ++i) {
            int hours = Integer.parseInt(earlyWarns[i]);
            if (hours < 1) continue;
            Date dateFrom = SrcDateUtils.addDateByHours((Date)currentDate, (int)hours);
            dateFrom = SrcDateUtils.addDateBySeconds((Date)dateFrom, (int)(-offsets * 60));
            Date dateTo = SrcDateUtils.addDateByHours((Date)currentDate, (int)hours);
            dateTo = SrcDateUtils.addDateBySeconds((Date)dateTo, (int)(offsets * 60));
            QFilter qfilter = new QFilter(planOpenDate, ">", (Object)dateFrom).and(planOpenDate, "<", (Object)dateTo);
            if (allQfilter == null) {
                allQfilter = qfilter;
                continue;
            }
            allQfilter.or(qfilter);
        }
        if (null != allQfilter) {
            return this.getQFilterMap(allQfilter, null);
        }
        return new HashMap<String, Object>(2);
    }
}

