/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;

public class SrmEvaPlanBatchAvgWeightOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("weightstrategy");
        e.getFieldKeys().add("entryentity.indexclass");
        e.getFieldKeys().add("entryentity.scorerweight");
        e.getFieldKeys().add("evasupentry");
        e.getFieldKeys().add("evascorersubentry");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String billName = data.getDynamicObjectType().getName();
            String evaSupEntry = "entryentity";
            String evaScorerSubEntry = "subentryentity";
            String indexClass = "indexclass";
            String scorerWeight = "scorerweight";
            if ("srm_groupevaplan".equals(billName)) {
                evaSupEntry = "evasupentry";
                evaScorerSubEntry = "evascorersubentry";
                indexClass = "evaindexclass";
                scorerWeight = "evascorerweight";
            } else if ("srm_autoevatpl".equals(billName)) {
                evaSupEntry = "evasupentry";
                evaScorerSubEntry = "evascorerentry";
                indexClass = "evaindexclass";
                scorerWeight = "evascorerweight";
            }
            DynamicObjectCollection supplierEntry = data.getDynamicObjectCollection(evaSupEntry);
            for (DynamicObject supplierEntryRow : supplierEntry) {
                String weightstrategy = supplierEntryRow.getString("weightstrategy");
                HashMap<String, Integer> scorerInfoMap = new HashMap<String, Integer>(16);
                if (!"A".equals(weightstrategy)) continue;
                DynamicObjectCollection subentryentity = supplierEntryRow.getDynamicObjectCollection(evaScorerSubEntry);
                for (DynamicObject scorerRow : subentryentity) {
                    long indexclassId = scorerRow.getLong(indexClass + ".id");
                    String key = indexclassId + "";
                    Integer sum = (Integer)scorerInfoMap.get(key);
                    if (sum == null) {
                        scorerInfoMap.put(key, 1);
                        continue;
                    }
                    scorerInfoMap.put(key, (Integer)scorerInfoMap.get(key) + 1);
                }
                HashMap<String, Integer> setNewWeightMap = new HashMap<String, Integer>(16);
                for (DynamicObject scorerRow : subentryentity) {
                    long indexclassId = scorerRow.getLong(indexClass + ".id");
                    String key = indexclassId + "";
                    Integer sum = (Integer)scorerInfoMap.get(key);
                    BigDecimal avgWeight = new BigDecimal(1).divide(new BigDecimal(sum), 4, 5);
                    Integer setSum = (Integer)setNewWeightMap.get(key);
                    if (setSum == null) {
                        setNewWeightMap.put(key, 1);
                        setSum = 1;
                    } else {
                        setNewWeightMap.put(key, (Integer)setNewWeightMap.get(key) + 1);
                        setSum = (Integer)setNewWeightMap.get(key);
                    }
                    if (sum.equals(setSum)) {
                        scorerRow.set(scorerWeight, (Object)new BigDecimal(1).subtract(avgWeight.multiply(new BigDecimal(sum - 1))).multiply(new BigDecimal(100)));
                        continue;
                    }
                    scorerRow.set(scorerWeight, (Object)avgWeight.multiply(new BigDecimal(100)));
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
    }
}

