/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.SrmEvaPlanStatusEnum;

public class SrmEvaPlanBatchPushOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("bizstatus");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("scheme");
        e.getFieldKeys().add("entryentity.supplier");
        e.getFieldKeys().add("entryentity.category");
        e.getFieldKeys().add("entryentity.material");
        e.getFieldKeys().add("subentryentity");
        e.getFieldKeys().add("subentryentity.indexclass");
        e.getFieldKeys().add("subentryentity.scorer");
        e.getFieldKeys().add("subentryentity.scorerweight");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            obj.set("bizstatus", (Object)SrmEvaPlanStatusEnum.TOBESCORE);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            Map<String, List<Object>> mp = this.getInfoMap(data);
            this.setIndexEntryInfo(data);
            this.setScorerEntryInfo(data, mp);
        }
    }

    private Map<String, List<Object>> getInfoMap(DynamicObject data) {
        HashMap<String, List<Object>> mp = new HashMap<String, List<Object>>(16);
        DynamicObjectCollection supplierEntry = data.getDynamicObjectCollection("entryentity");
        for (DynamicObject supplierRow : supplierEntry) {
            long supplierId = supplierRow.getLong("supplier.id");
            long categoryId = supplierRow.getLong("category.id");
            long materialId = supplierRow.getLong("material.id");
            long schemeId = supplierRow.getLong("scheme.id");
            String key = supplierId + "-" + categoryId + "-" + materialId + "-" + schemeId;
            DynamicObjectCollection scorerEntry = supplierRow.getDynamicObjectCollection("subentryentity");
            ArrayList<Number> scorerInfo = new ArrayList<Number>(10);
            for (DynamicObject scorerRow : scorerEntry) {
                long indexclassId = scorerRow.getLong("indexclass.id");
                long scorerId = scorerRow.getLong("scorer.id");
                BigDecimal scorerweight = scorerRow.getBigDecimal("scorerweight");
                scorerInfo.add(indexclassId);
                scorerInfo.add(scorerId);
                scorerInfo.add(scorerweight);
            }
            mp.put(key, scorerInfo);
        }
        return mp;
    }

    private void setIndexEntryInfo(DynamicObject data) {
        DynamicObject[] srm_scores;
        String billno = data.getString("billno");
        String selects = "id,bizstatus,taskbillid,supplier,category,material,scheme,entry,entry.index,entry.manscore,entry.veto,entry.indexweight,entry.finalscore,entry.indexscored,subentry,subentry.scorer,subentry.scorerweight,subentry.scorerveto";
        for (DynamicObject srm_score : srm_scores = BusinessDataServiceHelper.load((String)"srm_score", (String)selects, (QFilter[])new QFilter[]{new QFilter("taskbillno", "=", (Object)billno)})) {
            long schemeId = srm_score.getLong("scheme.id");
            srm_score.set("taskbillid", (Object)data.getLong("id"));
            srm_score.set("bizstatus", (Object)"B");
            DynamicObjectCollection scoredEntry = srm_score.getDynamicObjectCollection("entry");
            this.setScoredEntry(scoredEntry, schemeId);
        }
        SaveServiceHelper.save((DynamicObject[])srm_scores);
    }

    private void setScorerEntryInfo(DynamicObject data, Map<String, List<Object>> mp) {
        DynamicObject[] srm_scores;
        String billno = data.getString("billno");
        String selects = "id,supplier,category,material,scheme,entry,entry.index,entry.manscore,entry.veto,entry.indexweight,entry.finalscore,entry.indexscored,subentry,subentry.scorer,subentry.scorerweight,subentry.scorerveto,subentry.scorerscored";
        for (DynamicObject srm_score : srm_scores = BusinessDataServiceHelper.load((String)"srm_score", (String)selects, (QFilter[])new QFilter[]{new QFilter("taskbillno", "=", (Object)billno)})) {
            long supplierId = srm_score.getLong("supplier.id");
            long categoryId = srm_score.getLong("category.id");
            long materialId = srm_score.getLong("material.id");
            long schemeId = srm_score.getLong("scheme.id");
            boolean istypescorer = this.getSchemeIstypescorer(schemeId);
            String key = supplierId + "-" + categoryId + "-" + materialId + "-" + schemeId;
            List<Object> scorerInfo = mp.get(key);
            DynamicObjectCollection scoredEntry = srm_score.getDynamicObjectCollection("entry");
            for (DynamicObject scoredEntryRow : scoredEntry) {
                String scoretype = scoredEntryRow.getString("index.scoretype");
                long indextypeId = scoredEntryRow.getLong("index.indextype.id");
                long indexclassId = scoredEntryRow.getLong("index.indexclass.id");
                DynamicObjectCollection scorerEntry = scoredEntryRow.getDynamicObjectCollection("subentry");
                if ("9".equals(scoretype)) {
                    DynamicObject newRow = scorerEntry.addNew();
                    newRow.set("scorerweight", (Object)new BigDecimal(100));
                    continue;
                }
                for (int i = 0; i < scorerInfo.size(); i += 3) {
                    long srm_indexclass = (Long)scorerInfo.get(i);
                    if (indextypeId != srm_indexclass && indexclassId != srm_indexclass) continue;
                    DynamicObject newRow = scorerEntry.addNew();
                    if (!"1".equalsIgnoreCase(scoretype)) continue;
                    newRow.set("scorer", scorerInfo.get(i + 1));
                    newRow.set("scorerweight", scorerInfo.get(i + 2));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])srm_scores);
    }

    private void setScoredEntry(DynamicObjectCollection scoredEntry, long schemeId) {
        DynamicObjectCollection srm_scheme = QueryServiceHelper.query((String)"srm_scheme", (String)"id,entryentity,entryentity.index,entryentity.weight", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        for (DynamicObject schemeIndexEntryRow : srm_scheme) {
            long index = schemeIndexEntryRow.getLong("entryentity.index");
            BigDecimal weight = schemeIndexEntryRow.getBigDecimal("entryentity.weight");
            DynamicObject newRow = scoredEntry.addNew();
            newRow.set("index", (Object)index);
            newRow.set("indexweight", (Object)weight);
            newRow.set("veto", (Object)"9");
        }
    }

    private boolean getSchemeIstypescorer(long schemeId) {
        DynamicObject srm_scheme = QueryServiceHelper.queryOne((String)"srm_scheme", (String)"id,istypescorer", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        return srm_scheme.getBoolean("istypescorer");
    }
}

