/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.common.util.CommonUtil;

public final class SrmEvaTplEnableOp
extends AbstractOperationServicePlugIn {
    private static final String SUFFIX_EVA = ".eva";
    private static final String EVT_SUBSCRIPTION = "evt_subscription";
    private static final String SPLIT = "-";
    private static final String EVT_EVENT = "evt_event";
    private static final long SERVICE_EXECUTE_PLUGIN = 904236026388547584L;
    private static final String EXECUTE_PLUGIN = "executePlugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("billobject");
        e.getFieldKeys().add("op");
        e.getFieldKeys().add("exectype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String exectype = data.getString("exectype");
            if ("2".equals(exectype)) {
                this.attachEvents(data);
            }
            this.pushAndSave(data);
        }
    }

    private DynamicObject newDynamicObject(String pushtype) {
        return BusinessDataServiceHelper.newDynamicObject((String)pushtype);
    }

    private void pushAndSave(DynamicObject data) {
        List<DynamicObject> targeBills = this.pushTargeBill(data.getPkValue(), "srm_autoevatpl", "srm_autoevatpl_ver");
        DynamicObjectCollection srm_autoevatpl_ver = QueryServiceHelper.query((String)"srm_autoevatpl_ver", (String)"id", (QFilter[])new QFilter[]{new QFilter("tplid", "=", (Object)String.valueOf(data.getPkValue()))});
        for (DynamicObject targeBill : targeBills) {
            targeBill.set("version", (Object)(srm_autoevatpl_ver.size() + 1));
            targeBill.set("tplid", data.getPkValue());
            targeBill.set("enable", (Object)"1");
            targeBill.set("status", (Object)"C");
            targeBill.set("vernumber", (Object)CodeRuleUtil.getCodeRule((String)"srm_autoevatpl_ver"));
        }
        SaveServiceHelper.save((DynamicObject[])targeBills.toArray(new DynamicObject[targeBills.size()]));
    }

    private List<DynamicObject> pushTargeBill(Object pkValue, String sourceBillName, String targetBillName) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceBillName);
        pushArgs.setTargetEntityNumber(targetBillName);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(pkValue);
        selectedRowList.add(row);
        pushArgs.setSelectedRows(selectedRowList);
        ArrayList<DynamicObject> targetData = new ArrayList(10);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!result.isSuccess()) {
            StringBuilder message = new StringBuilder();
            result.getBillReports().forEach(rowx -> message.append(rowx.getFailMessage()));
            if (message.length() == 0) {
                message.append(ResManager.loadKDString((String)"botp\u51fa\u73b0\u5f02\u5e38\u3002", (String)"SrmEvaTplEnableOp_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
        } else {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetBillName);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            targetData = result.loadTargetDataObjects(refDataProvider, mainType);
        }
        return targetData;
    }

    private void attachEvents(DynamicObject trigger) {
        this.createEvent(trigger);
        this.createEventSubscription(trigger);
    }

    private void createEventSubscription(DynamicObject trigger) {
        String billobject = trigger.getString("billobject.number");
        String op = trigger.getString("op");
        String eventNumber = billobject + "." + op;
        String eventSubscriptionNumber = eventNumber + SUFFIX_EVA;
        if (this.isEventExist(EVT_SUBSCRIPTION, eventSubscriptionNumber)) {
            return;
        }
        MainEntityType eventSubscriptionEntityType = EntityMetadataCache.getDataEntityType((String)EVT_SUBSCRIPTION);
        ArrayList<DynamicObject> newEventSubscriptionDyns = new ArrayList<DynamicObject>(1);
        Map<String, Long> eventNumberToEventIdMap = this.getEventNumberToEventIdMap(eventNumber);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
        DynamicObject newEventSubscriptionDyn = BusinessDataServiceHelper.newDynamicObject((String)EVT_SUBSCRIPTION);
        newEventSubscriptionDyn = ParameterUtils.createDefaultEntity((MainEntityType)eventSubscriptionEntityType, (DynamicObject)newEventSubscriptionDyn);
        newEventSubscriptionDyn.set("event", (Object)eventNumberToEventIdMap.get(eventNumber));
        newEventSubscriptionDyn.set("eventnumber", (Object)eventNumber);
        newEventSubscriptionDyn.set("number", (Object)eventSubscriptionNumber);
        newEventSubscriptionDyn.set("service", (Object)904236026388547584L);
        newEventSubscriptionDyn.set("servicenumber", (Object)EXECUTE_PLUGIN);
        newEventSubscriptionDyn.set("serviceconfig", (Object)"{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"srm\\\",\\\"class\\\":\\\"kd.scm.srm.common.autoeva.SrmOpExecAutoEvatplService\\\"}\"}");
        StringBuilder name = new StringBuilder(trigger.getString("name"));
        name.append(SPLIT);
        name.append(ResManager.loadKDString((String)"SRM\u7ee9\u6548\u81ea\u52a8\u89e6\u53d1", (String)"SrmEvaTplEnableOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        newEventSubscriptionDyn.set("name", (Object)name.toString());
        newEventSubscriptionDyns.add(newEventSubscriptionDyn);
        this.cache(billobject, cache, eventNumber);
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)EVT_SUBSCRIPTION, (DynamicObject[])newEventSubscriptionDyns.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create()));
    }

    private void cache(String indexEntityKey, DistributeSessionlessCache cache, String eventNumber) {
        cache.addToSet(RequestContext.get().getAccountId() + ".evt.cacheEvent." + indexEntityKey, new String[]{eventNumber}, Integer.MAX_VALUE);
    }

    private Map<String, Long> getEventNumberToEventIdMap(String eventNumber) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        DynamicObject eventDyn = QueryServiceHelper.queryOne((String)EVT_EVENT, (String)"id,number,numberview", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)eventNumber)});
        if (eventDyn != null) {
            res.put(eventDyn.getString("number"), eventDyn.getLong("id"));
        }
        return res;
    }

    private void createEvent(DynamicObject trigger) {
        String billobject = trigger.getString("billobject.number");
        String billobjectId = trigger.getString("billobject.id");
        String op = trigger.getString("op");
        String bizappid = trigger.getString("billobject.bizappid.id");
        String eventNumber = billobject + "." + op;
        if (this.isEventExist(EVT_EVENT, eventNumber)) {
            return;
        }
        MainEntityType eventEntityType = EntityMetadataCache.getDataEntityType((String)EVT_EVENT);
        ArrayList<DynamicObject> newEventDyns = new ArrayList<DynamicObject>(1);
        DynamicObject newEventDyn = BusinessDataServiceHelper.newDynamicObject((String)EVT_EVENT);
        newEventDyn = ParameterUtils.createDefaultEntity((MainEntityType)eventEntityType, (DynamicObject)newEventDyn);
        newEventDyn.set("number", (Object)eventNumber);
        newEventDyn.set("type", (Object)"cosmic");
        newEventDyn.set("entity", (Object)billobjectId);
        newEventDyn.set("source", (Object)bizappid);
        newEventDyn.set("numberview", (Object)(eventNumber + SUFFIX_EVA));
        newEventDyn.set("description", (Object)ResManager.loadKDString((String)"\u6b64\u4e8b\u4ef6\u7531SRM\u540e\u53f0\u81ea\u52a8\u521b\u5efa\u3002", (String)"SrmEvaTplEnableOp_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        newEventDyn.set("operation", (Object)op);
        StringBuilder name = new StringBuilder(trigger.getString("name"));
        name.append(SPLIT);
        name.append(ResManager.loadKDString((String)"SRM\u7ee9\u6548\u81ea\u52a8\u89e6\u53d1", (String)"SrmEvaTplEnableOp_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        newEventDyn.set("name", (Object)name.toString());
        newEventDyns.add(newEventDyn);
        CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)EVT_EVENT, (DynamicObject[])newEventDyns.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create()));
    }

    private boolean isEventExist(String meta, String number) {
        return QueryServiceHelper.exists((String)meta, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
    }
}

